/*
 * Decompiled with CFR 0.152.
 */
package toxi.geom.mesh;

import toxi.geom.Triangle3D;
import toxi.geom.Vec2D;
import toxi.geom.Vec3D;
import toxi.geom.mesh.Vertex;

public class Face {
    public Vertex a;
    public Vertex b;
    public Vertex c;
    public Vec2D uvA;
    public Vec2D uvB;
    public Vec2D uvC;
    public Vec3D normal;

    public Face(Vertex vertex, Vertex vertex2, Vertex vertex3) {
        this.a = vertex;
        this.b = vertex2;
        this.c = vertex3;
        this.normal = vertex.sub(vertex3).crossSelf(vertex.sub(vertex2)).normalize();
        vertex.addFaceNormal(this.normal);
        vertex2.addFaceNormal(this.normal);
        vertex3.addFaceNormal(this.normal);
    }

    public Face(Vertex vertex, Vertex vertex2, Vertex vertex3, Vec2D vec2D, Vec2D vec2D2, Vec2D vec2D3) {
        this(vertex, vertex2, vertex3);
        this.uvA = vec2D;
        this.uvB = vec2D2;
        this.uvC = vec2D3;
    }

    public void computeNormal() {
        this.normal = this.a.sub(this.c).crossSelf(this.a.sub(this.b)).normalize();
    }

    public void flipVertexOrder() {
        Vertex vertex = this.a;
        this.a = this.b;
        this.b = vertex;
        this.normal.invert();
    }

    public Vec3D getCentroid() {
        return this.a.add(this.b).addSelf(this.c).scale(0.33333334f);
    }

    public final Vertex[] getVertices(Vertex[] vertexArray) {
        if (vertexArray != null) {
            vertexArray[0] = this.a;
            vertexArray[1] = this.b;
            vertexArray[2] = this.c;
        } else {
            vertexArray = new Vertex[]{this.a, this.b, this.c};
        }
        return vertexArray;
    }

    public String toString() {
        return this.getClass().getName() + " " + this.a + ", " + this.b + ", " + this.c;
    }

    public Triangle3D toTriangle() {
        return new Triangle3D(this.a.copy(), this.b.copy(), this.c.copy());
    }
}

