/*
 * Decompiled with CFR 0.152.
 */
package toxi.geom;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import toxi.geom.Ray3D;
import toxi.geom.ReadonlyVec3D;
import toxi.geom.Shape3D;
import toxi.geom.Triangle3D;
import toxi.geom.Vec3D;
import toxi.geom.mesh.Mesh3D;
import toxi.geom.mesh.SphereFunction;
import toxi.geom.mesh.SurfaceMeshBuilder;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class Sphere
extends Vec3D
implements Shape3D {
    @XmlAttribute(required=true)
    public float radius;

    public Sphere() {
        this(new Vec3D(), 1.0f);
    }

    public Sphere(float f) {
        this(new Vec3D(), f);
    }

    public Sphere(ReadonlyVec3D readonlyVec3D, float f) {
        super(readonlyVec3D);
        this.radius = f;
    }

    public Sphere(Sphere sphere) {
        this(sphere, sphere.radius);
    }

    public boolean containsPoint(ReadonlyVec3D readonlyVec3D) {
        float f = this.sub(readonlyVec3D).magSquared();
        return f <= this.radius * this.radius;
    }

    public float[] intersectRay(Ray3D ray3D) {
        float f;
        float[] fArray = null;
        Vec3D vec3D = ray3D.sub(this);
        float f2 = vec3D.magSquared();
        float f3 = this.radius * this.radius - (f2 - (f = -vec3D.dot((ReadonlyVec3D)ray3D.getDirection())) * f);
        if ((double)f3 >= 0.0) {
            f3 = (float)Math.sqrt(f3);
            float f4 = f + f3;
            float f5 = f - f3;
            if (!(f4 < 0.0f) || !(f5 < 0.0f)) {
                if (f4 > 0.0f && f5 > 0.0f) {
                    if (f4 > f5) {
                        float f6 = f4;
                        f4 = f5;
                        f5 = f6;
                    }
                } else if (f5 > 0.0f) {
                    float f7 = f4;
                    f4 = f5;
                    f5 = f7;
                }
            }
            fArray = new float[]{f4, f5};
        }
        return fArray;
    }

    public boolean intersectSphereTriangle(Triangle3D triangle3D, Vec3D vec3D) {
        vec3D.set(triangle3D.closestPointOnSurface(this));
        Vec3D vec3D2 = vec3D.sub(this);
        return vec3D2.magSquared() <= this.radius * this.radius;
    }

    public Vec3D tangentPlaneNormalAt(ReadonlyVec3D readonlyVec3D) {
        return this.sub(readonlyVec3D).normalize();
    }

    public Mesh3D toMesh(int n) {
        return this.toMesh(null, n);
    }

    public Mesh3D toMesh(Mesh3D mesh3D, int n) {
        SurfaceMeshBuilder surfaceMeshBuilder = new SurfaceMeshBuilder(new SphereFunction(this));
        return surfaceMeshBuilder.createMesh(mesh3D, n, 1.0f);
    }
}

