/*
 * Decompiled with CFR 0.152.
 */
import ddf.minim.AudioPlayer;
import ddf.minim.Minim;
import ddf.minim.analysis.FFT;
import moonlander.library.Moonlander;
import processing.core.PApplet;

public class demo
extends PApplet {
    final int CANVAS_WIDTH = 1920;
    final int CANVAS_HEIGHT = 1080;
    final int CUBES_IN_ROW = 64;
    final int CUBES_IN_COLUMN = 32;
    final int CUBE_WIDTH = 25;
    final int CUBE_HEIGHT = 20;
    int FLASH_ROW = 0;
    int FLASH_ROW_DIRECTION = 1;
    float WAVE_HEIGHT = 0.0f;
    int TEXT_Y_POS_OFFSET = 500;
    DemoCube[][] cubes = new DemoCube[64][32];
    Minim minim;
    AudioPlayer song;
    FFT fft;
    Moonlander moonlander;

    public void setup() {
        this.size(this.displayWidth, this.displayHeight, "processing.opengl.PGraphics3D");
        this.noStroke();
        this.frameRate(30.0f);
        this.smooth();
        this.initCubes();
        this.setupAudio();
    }

    public void setupAudio() {
        this.minim = new Minim((Object)this);
        this.song = this.minim.loadFile("Rune_Factory_-_8_Bit_Adventurer_short.wav");
        this.moonlander = Moonlander.initWithSoundtrack((PApplet)this, (String)"dialup.wav", (int)127, (int)8);
        this.fft = new FFT(this.song.bufferSize(), this.song.sampleRate());
        this.moonlander.start();
    }

    public void draw() {
        int n;
        this.moonlander.update();
        this.background(0.0f, 0.0f, 0.0f);
        float f = (float)this.millis() / 1000.0f;
        int n2 = (int)this.moonlander.getValue("startWaves");
        if (n2 != 0 || this.song.isPlaying()) {
            this.fft.forward(this.song.mix);
            this.cubeWaves(f);
        }
        if ((n = (int)this.moonlander.getValue("startSong")) != 0 && !this.song.isPlaying()) {
            this.song.play();
        }
        if (f > 52.0f) {
            this.exit();
        }
        this.translate(this.width / 2, this.height / 2, 0.0f);
        this.flashRows(this.FLASH_ROW);
        if (f > (float)(this.FLASH_ROW / 100)) {
            int n3 = (int)this.moonlander.getValue("flashRowLoop");
            if (n3 == 1) {
                this.FLASH_ROW += this.FLASH_ROW_DIRECTION;
                if (this.FLASH_ROW == 64) {
                    this.FLASH_ROW_DIRECTION = -1;
                    this.FLASH_ROW += this.FLASH_ROW_DIRECTION;
                }
                if (this.FLASH_ROW < 0) {
                    this.FLASH_ROW_DIRECTION = 1;
                    this.FLASH_ROW += this.FLASH_ROW_DIRECTION;
                }
            } else {
                ++this.FLASH_ROW;
                this.FLASH_ROW %= 64;
            }
        }
        this.translate(0.0f, 100.0f, -50.0f);
        this.fill(255);
        if ((float)this.song.position() / 1000.0f > 24.0f) {
            this.drawText();
        }
        this.pushMatrix();
        this.rotateX(12.3f);
        this.drawCubes();
        this.callCubes();
        this.popMatrix();
    }

    public void callCubes() {
        int n = (int)this.moonlander.getValue("x");
        int n2 = (int)this.moonlander.getValue("y");
        if (n == 0 || n2 == 0) {
            return;
        }
        this.cubes[n][n2].setH(40.0f);
        this.cubes[n][n2].draw(0.0f, 255.0f, 0.0f);
        int n3 = n > 5 ? n - 5 : 0;
        int n4 = n2 > 5 ? n2 - 5 : 0;
        int n5 = n + 5 > 64 ? 64 : n + 5;
        int n6 = n2 + 5 > 32 ? 32 : n2 + 5;
        int n7 = n3;
        while (n7 < n5) {
            int n8 = n4;
            while (n8 < n6) {
                this.cubes[n7][n8].draw(0.0f, 255.0f * (1.0f / demo.dist((float)n, (float)n2, (float)n7, (float)n8)), 0.0f);
                ++n8;
            }
            ++n7;
        }
    }

    public void drawText() {
        if (this.TEXT_Y_POS_OFFSET > 70) {
            this.TEXT_Y_POS_OFFSET -= 8;
        }
        this.pushMatrix();
        this.textSize(72.0f);
        this.fill(255.0f, 0.0f, 0.0f);
        this.text("BeatCubes", -1060.0f, -390 - this.TEXT_Y_POS_OFFSET, -100.0f);
        this.textSize(24.0f);
        this.text("Music: 8 Bit Adventurer by Rune Factory", -1060.0f, -540 - this.TEXT_Y_POS_OFFSET, -100.0f);
        this.popMatrix();
    }

    public void cubeWaves(float f) {
        int n = 0;
        while (n < 64) {
            int n2 = 0;
            while (n2 < 32) {
                this.cubes[n][n2].setY((demo.sin((float)(f * 5.0f + (float)n)) * 10.0f * this.WAVE_HEIGHT + demo.sin((float)(f * 5.0f + (float)n2)) * 10.0f * 0.3f) * this.WAVE_HEIGHT);
                ++n2;
            }
            ++n;
        }
        if (this.WAVE_HEIGHT < 1.0f && (float)this.song.position() / 1000.0f < 27.0f) {
            this.WAVE_HEIGHT += 0.05f;
        } else if (this.WAVE_HEIGHT > 0.0f) {
            this.WAVE_HEIGHT -= 0.05f;
        } else if ((float)this.song.position() / 1000.0f < 29.0f) {
            this.song.close();
        }
    }

    public void initCubes() {
        int n = 0;
        while (n < 64) {
            int n2 = 0;
            while (n2 < 32) {
                this.cubes[n][n2] = new DemoCube(25 * n - 800, 0.0f, -25 * n2, 20.0f);
                ++n2;
            }
            ++n;
        }
    }

    public void drawCubes() {
        int n = 0;
        while (n < 64) {
            int n2 = 0;
            while (n2 < 32) {
                this.cubes[n][n2].draw();
                ++n2;
            }
            ++n;
        }
    }

    public void flashRows(int n) {
        int n2;
        int n3 = 0;
        while (n3 < 64) {
            if (n3 != n) {
                n2 = 0;
                while (n2 < 32) {
                    this.cubes[n3][n2].flash(demo.floor((float)((float)this.cubes[n3][n2].getR() * 0.7f)), demo.floor((float)((float)this.cubes[n3][n2].getG() * 0.7f)), demo.floor((float)((float)this.cubes[n3][n2].getB() * 0.7f)));
                    float f = this.cubes[n3][n2].getH();
                    f = this.cubes[n3][n2].getH() > 20.0f ? (f -= 5.0f) : 20.0f;
                    this.cubes[n3][n2].setH(f);
                    ++n2;
                }
            }
            ++n3;
        }
        float f = this.fft.getBand(this.fft.specSize() / (n + 1)) * 10.0f;
        n2 = 0;
        while (n2 < 32) {
            int n4 = (int)this.moonlander.getValue("flashColorRed");
            int n5 = (int)this.moonlander.getValue("flashColorGreen");
            int n6 = (int)this.moonlander.getValue("flashColorBlue");
            this.cubes[n][n2].flash(n4, n5, n6);
            float f2 = f - (float)(10 * (n2 < 16 ? 16 - n2 : n2 - 16));
            if (f2 < 20.0f) {
                f2 = 20.0f;
            }
            this.cubes[n][n2].setH(f2);
            ++n2;
        }
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"--full-screen", "--bgcolor=#666666", "--hide-stop", "demo"};
        if (stringArray != null) {
            PApplet.main((String[])demo.concat((String[])stringArray2, (String[])stringArray));
        } else {
            PApplet.main((String[])stringArray2);
        }
    }

    class DemoCube {
        float x;
        float y;
        float z;
        float h;
        int r;
        int g;
        int b;

        DemoCube(float f, float f2, float f3, float f4) {
            this.x = f;
            this.y = f2;
            this.z = f3;
            this.h = f4;
            this.r = 0;
            this.g = 0;
            this.g = 0;
        }

        public float getX() {
            return this.x;
        }

        public float getY() {
            return this.y;
        }

        public float getZ() {
            return this.z;
        }

        public float getH() {
            return this.h;
        }

        public void setX(float f) {
            this.x = f;
        }

        public void setY(float f) {
            this.y = f;
        }

        public void setZ(float f) {
            this.z = f;
        }

        public void setH(float f) {
            this.h = f;
        }

        public int getR() {
            return this.r;
        }

        public int getG() {
            return this.g;
        }

        public int getB() {
            return this.b;
        }

        public void draw() {
            demo.this.pushMatrix();
            demo.this.translate(this.x, this.y, this.z);
            demo.this.stroke(255.0f, 0.0f, 0.0f);
            demo.this.fill(this.r, this.g, this.b);
            demo.this.box(20.0f, this.h, 20.0f);
            demo.this.popMatrix();
        }

        public void draw(float f, float f2, float f3) {
            demo.this.pushMatrix();
            demo.this.translate(this.x, this.y, this.z);
            demo.this.stroke(255.0f, 0.0f, 0.0f);
            demo.this.fill(f, f2, f3);
            demo.this.box(20.0f, this.h, 20.0f);
            demo.this.popMatrix();
        }

        public void flash(int n, int n2, int n3) {
            this.r = n;
            this.g = n2;
            this.b = n3;
        }
    }
}

