varying vec2 out_texcoord;
varying vec4 out_color;

uniform sampler2D color_map;
uniform vec2 hdr_params;

void main()
{
	vec4 texel_color = texture2D( color_map, out_texcoord);

	vec4 result_color = texel_color * out_color * 6.0 - 0.1;

	expose( result_color.xyz, hdr_params.x, hdr_params.y);

	gl_FragColor.xyz = result_color.xyz;
	gl_FragColor.w = texel_color.x * out_color.w * 2.0;
	//gl_FragColor = vec4( 1.0);
	
	// if( gl_FragColor.w < 0.01) discard;
}
