#define PI 3.1415268

uniform sampler2D color_map;
uniform sampler2D depth_map;
uniform vec4 depth_parameters;
uniform vec4 corners[4];
uniform vec2 inv_resolution;

varying vec2 out_texcoord0;

//https://gist.github.com/fisch0920/6770311
//https://research.nvidia.com/publication/scalable-ambient-obscurance

//total number of samples at each fragment
 #define NUM_SAMPLES           10
 #define NUM_SPIRAL_TURNS      6

// #define NUM_SAMPLES           32
// #define NUM_SPIRAL_TURNS      3

// #define NUM_SAMPLES           64
// #define NUM_SPIRAL_TURNS      17
 
#define VARIATION             1

#define uSampleRadiusWS 0.1
 
float rand(vec2 co)
{
	return (fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453));
}

	
// reconstructs view-space unit normal from view-space position
#if 0
vec3 reconstructNormalVS(vec3 positionVS) 
{
  return normalize(cross(dFdx(positionVS), dFdy(positionVS)));
}
#endif
 
vec3 getPositionVS(vec2 uv) 
{
	float d  = texture2D( depth_map, uv).x; 
	d = depth_parameters.y / (d - depth_parameters.x);

	vec3 dir0;
	vec3 dir1;
	vec3 dir2;
	
	dir0 = mix( corners[0].xyz, corners[1].xyz, uv.x);
	dir1 = mix( corners[2].xyz, corners[3].xyz, uv.x);
	dir2 = mix( dir0, dir1, uv.y);
	return d * dir2;
}
 
vec3 reconstructNormalVS2( vec2 uv) 
{
  const vec2 offset1 = vec2(0.2 / 1280.0,0.0);
  const vec2 offset2 = vec2(0.0, 0.2 / 720.0);
  
  
#if 0
  float depth = texture2D( depth_map, uv).r;
  float depth1 = texture2D( depth_map, uv + offset1).r;
  float depth2 = texture2D( depth_map, uv + offset2).r;
  
  vec3 p1 = vec3(offset1, depth1 - depth);
  vec3 p2 = vec3(offset2, depth2 - depth);
  
  vec3 normal = cross( p1, p2);
  normal.z = -normal.z;

  return normalize( normal);
#endif

	vec3 p0 = getPositionVS( uv);
	vec3 p1 = getPositionVS( uv + offset1);
	vec3 p2 = getPositionVS( uv + offset2);
	
  return normalize(cross(p1-p0, p2-p0));
	
}


// returns a unit vector and a screen-space radius for the tap on a unit disk 
// (the caller should scale by the actual disk radius)
vec3 tapLocation(int sampleNumber, float spinAngle) 
{
  // radius relative to radiusSS
  float alpha = (float(sampleNumber) + 0.5) * (1.0 / float(NUM_SAMPLES));
  float angle = alpha * (float(NUM_SPIRAL_TURNS) * 2.0 * PI) + spinAngle;
  
  return vec3(cos(angle), sin(angle), alpha);
}
 
 
float sampleAO(vec2 uv, vec3 positionVS, vec3 normalVS, float sampleRadiusSS, int tapIndex, float rotationAngle)
{
	//epsilon2 - csalas a melysegi radiusszal, hogy teltebb legyen a AO
	//epsilon1 - az epsilon2 hibajat csokkenti
  const float epsilon1 = 0.004;
  const float epsilon2 = 4.0;
  const float depth_precision_epsilon = 0.01;
  const float radius2 = uSampleRadiusWS * uSampleRadiusWS * epsilon2;
  
  // offset on the unit disk, spun for this pixel
  vec3 unitOffset = tapLocation(tapIndex, rotationAngle);
  float radiusSS = sampleRadiusSS * unitOffset.z;
  
  vec3 Q = getPositionVS( uv + unitOffset.xy * radiusSS);
  vec3 v = Q - positionVS;
  
  float vv = dot(v, v);
  float vn = dot(v, normalVS) - depth_precision_epsilon;
  
#if VARIATION == 0
  
  // (from the HPG12 paper)
  // Note large epsilon to avoid overdarkening within cracks
  return float(vv < radius2) * max(vn / (epsilon1 + vv), 0.0);
  
#elif VARIATION == 1 // default / recommended
  
  // Smoother transition to zero (lowers contrast, smoothing out corners). [Recommended]
  float f = max(radius2 - vv, 0.0) / radius2;
  return f * max(vn / (epsilon1 + vv), 0.0);
  
#elif VARIATION == 2
  
  // Medium contrast (which looks better at high radii), no division.  Note that the 
  // contribution still falls off with radius^2, but we've adjusted the rate in a way that is
  // more computationally efficient and happens to be aesthetically pleasing.
  float invRadius2 = 1.0 / radius2;
  return 128.0 * max(1.0 - vv * invRadius2, 0.0) * max(vn, 0.0);
  
#else

  // Low contrast, no division operation
  return 128.0 * float(vv < radius2) * max(vn, 0.0);
  
#endif
}


void main() 
{
	vec3 originVS = getPositionVS( out_texcoord0);
	//vec3 normalVS = reconstructNormalVS( originVS);
	vec3 normalVS = reconstructNormalVS2( out_texcoord0);

	float randomPatternRotationAngle = 2.0 * PI * rand( out_texcoord0);

	float occlusion = 0.0;

	float radiusSS = -uSampleRadiusWS / originVS.z;

	for (int i = 0; i < NUM_SAMPLES; ++i) 
	{
		occlusion += sampleAO(out_texcoord0, originVS, normalVS, radiusSS, i, randomPatternRotationAngle);
	}

	occlusion = 1.0 - occlusion / float(  NUM_SAMPLES);
	//occlusion = 1.0;
	gl_FragColor = vec4( occlusion, occlusion, occlusion, 1.0);
	//gl_FragColor = vec4( normalVS, 1.0);
}
