uniform mat4 mvp;
uniform vec4 bones_x[32];
uniform vec4 bones_y[32];
uniform vec4 bones_z[32];

attribute vec3 in_position;
attribute vec4 in_texcoord;
attribute vec4 in_color;
attribute vec3 in_normal;
attribute vec4 in_bone_indices;
attribute vec4 in_bone_weights;

varying vec2 out_texcoord0;
varying vec2 out_texcoord1;
varying vec4 out_color;
varying vec3 out_normal;
varying vec3 out_pos;

void main()
{    
#if defined STATIC
	gl_Position = mvp * vec4( in_position, 1.0);
#elif defined SKELETAL
	ivec4 bone_indices = ivec4(in_bone_indices);

	mat3 m0 = in_bone_weights.x * mat3( bones_x[bone_indices.x].xyz, bones_y[bone_indices.x].xyz, bones_z[bone_indices.x].xyz);
	mat3 m1 = in_bone_weights.y * mat3( bones_x[bone_indices.y].xyz, bones_y[bone_indices.y].xyz, bones_z[bone_indices.y].xyz);
	mat3 m2 = in_bone_weights.z * mat3( bones_x[bone_indices.z].xyz, bones_y[bone_indices.z].xyz, bones_z[bone_indices.z].xyz);
	mat3 m3 = in_bone_weights.w * mat3( bones_x[bone_indices.w].xyz, bones_y[bone_indices.w].xyz, bones_z[bone_indices.w].xyz);

	vec3 p0 = in_bone_weights.x * vec3( bones_x[bone_indices.x].w, bones_y[bone_indices.x].w, bones_z[bone_indices.x].w);
	vec3 p1 = in_bone_weights.y * vec3( bones_x[bone_indices.y].w, bones_y[bone_indices.y].w, bones_z[bone_indices.y].w);
	vec3 p2 = in_bone_weights.z * vec3( bones_x[bone_indices.z].w, bones_y[bone_indices.z].w, bones_z[bone_indices.z].w);
	vec3 p3 = in_bone_weights.w * vec3( bones_x[bone_indices.w].w, bones_y[bone_indices.w].w, bones_z[bone_indices.w].w);
	
	mat3 m = m0 + m1 + m2 + m3;
	vec3 p = p0 + p1 + p2 + p3;

	vec3 world_position = m * in_position + p;
	
	gl_Position = mvp * vec4( world_position, 1.0);
#else
	gl_Position = mvp * vec4( in_position, 1.0);
#endif

	out_texcoord0 = in_texcoord.xy;
	out_texcoord1 = in_texcoord.zw;
	out_color = in_color;
	out_normal = in_normal;
	out_pos = in_position;
}
