
#undef UNICODE
#include "bass24/bass.h"


HMUSIC hmusic; //bass music handle

void MusicInit(const char* musicfile)
{
  BASS_Init(-1,44100,0,0,0); //default init, use default stuff
  hmusic = BASS_MusicLoad(false, musicfile, 0, 0, 0, 0);
  
  if(hmusic == 0) throw "Failed to load music";
}

void MusicPlay()
{
  BASS_ChannelPlay(hmusic,true);
}

long long MusicGetPositionByte()
{
  return BASS_ChannelGetPosition(hmusic,BASS_POS_BYTE);
}
            
int MusicGetModRow()
{                                             
  return HIWORD(BASS_ChannelGetPosition(hmusic,BASS_POS_MUSIC_ORDER));
}

int MusicGetModOrder()
{                           
  return LOWORD(BASS_ChannelGetPosition(hmusic,BASS_POS_MUSIC_ORDER));
}

void MusicSetModOrder(int order)
{
  BASS_ChannelSetPosition(hmusic,MAKELONG(order,0),BASS_POS_MUSIC_ORDER);
}



