/*

--------
|SKRUZD|
--------

The MIT License

Copyright (c) 2006 Inko Illarramendi

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/


#include <crystalspace.h>

#include <physicallayer/entity.h>
#include <physicallayer/propclas.h>
#include <propclass/linmove.h>
#include <propclass/prop.h>
#include <propclass/trigger.h>
#include <propclass/region.h>

#include <propclass/tooltip.h>
#include <propclass/timer.h>
#include <propclass/move.h>
#include <propclass/input.h>
#include <propclass/solid.h>
#include <propclass/colldet.h>

#include "behave.h"
#include "bshoot.h"


BehaviourShoot::BehaviourShoot (iCelEntity* entity, BehaviourLayer* bl, iCelPlLayer* pl)
        : BehaviourCommon (entity, bl, pl, app)
{
    id_pctimer_wakeup = pl->FetchStringID ("pctimer_wakeup");
}

bool BehaviourShoot::SendMessage (csStringID msg_id,
                                  iCelPropertyClass* pc,
                                  celData& ret, iCelParameterBlock* params, va_list arg)
{
    entity = pc-> GetEntity();

    if (msg_id == id_pctimer_wakeup)
    {/// The entity's life time is over so we remove it.
        pl->RemoveEntity (entity);
        return true;
    }
    return BehaviourCommon::SendMessage (msg_id, pc, ret, params, arg);

}
