/*

--------
|SKRUZD|
--------

The MIT License

Copyright (c) 2006 Inko Illarramendi

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/


#ifndef BEHAVE_H
#define BEHAVE_H

#include <physicallayer/pl.h>
#include <behaviourlayer/bl.h>
#include <behaviourlayer/behave.h>
#include <propclass/actormove.h>
#include <propclass/meshsel.h>
#include <propclass/mesh.h>
#include <propclass/camera.h>
#include <propclass/inv.h>

#include <propclass/mover.h>

#include "app.h"


class BehaviourLayer : public iCelBlLayer
{
private:
    iCelPlLayer* pl;

public:
    BehaviourLayer (iCelPlLayer* pl);
    virtual ~BehaviourLayer ();

    SCF_DECLARE_IBASE;

    virtual const char* GetName () const
    {
        return "behaviourlayer";
    }
    virtual iCelBehaviour* CreateBehaviour (iCelEntity* entity, const char* name);
};

class BehaviourCommon : public iCelBehaviour
{
protected:
    MainApp* app;
    iCelEntity* entity;
    BehaviourLayer* bl;
    iCelPlLayer* pl;

public:
    BehaviourCommon (iCelEntity* entity, BehaviourLayer* bl, iCelPlLayer* pl, MainApp* app);
    virtual ~BehaviourCommon ();

    /**
     * This is a specific version of SendMessage() that accepts
     * an integer instead of a csStringID. Subclasses of ccBehaviourBase
     * will only have to override this version. The normal iCelBehaviour
     * versions of SendMessage() are implemented in this class and
     * will redirect to this version.
     */
    virtual bool SendMessage (csStringID msg_id,
                              iCelPropertyClass* pc,
                              celData& ret, iCelParameterBlock* params, va_list arg);

    SCF_DECLARE_IBASE;

    virtual iCelBlLayer* GetBehaviourLayer () const
    {
        return bl;
    }
    virtual bool SendMessage (const char* msg_id,
                              iCelPropertyClass* pc,
                              celData& ret, iCelParameterBlock* params, ...);
    virtual bool SendMessageV (const char* msg_id,
                               iCelPropertyClass* pc,
                               celData& ret, iCelParameterBlock* params, va_list arg);
    virtual void* GetInternalObject ()
    {
        return 0;
    }
};

#endif
