var $body,
  $demos,
  $coverflow,
  coverflowFaces,
  shadeAmount,
  tintAmount,
  light,
  currentCover,
  renderTimer,
  isLit,
  domTransformProperty,
  cssTransformProperty,
  domTransitionProperty,
  cssTransitionProperty,
  transitionEndEvent,
  transitionEndEvents = {
    'WebkitTransition' : 'webkitTransitionEnd',
    'MozTransition'    : 'transitionend',
    'OTransition'      : 'oTransitionEnd',
    'msTransition'     : 'MSTransitionEnd',
    'transition'       : 'transitionend'
  };

var currentIndex = 0;



$(document).ready(function() {
  $body = $('body');
  $demos = $('.demo');
  light = new Photon.Light();
  shadeAmount = .6;
  tintAmount = 0;
  coverflowFaces = [];
  currentCover = 0;
  isLit = true;
  domTransformProperty = Modernizr.prefixed('transform');
  cssTransformProperty = domToCss(domTransformProperty);
  domTransitionProperty = Modernizr.prefixed('transition');
  cssTransitionProperty = domToCss(domTransitionProperty);
  transitionEndEvent = transitionEndEvents[domTransitionProperty];

  setupCoverflow();


  setTimeout(function() {
    rotateCoverflow();
  }, 1700);
  setTimeout(function() {
    rotateCoverflow();
  }, 3400);
  setTimeout(function() {
    rotateCoverflow();
  }, 4600);
  setTimeout(function() {
    rotateCoverflow();
  }, 6300);
  setTimeout(function() {
    rotateCoverflow();
  }, 8000);
  setTimeout(function() {
    rotateCoverflow();
  }, 9700);

  $("body").keypress(function() {
    rotateCoverflow();
  });


  $("body").keydown(function(e) {
    if(e.which == 37) {
      rotateCoverflow(); // left
    }
    else if(e.which == 39) {
      rotateCoverflow(); // right
    }
  });

});

function setupCoverflow() {
  $coverflow = $('.coverflow');
  var $coverflowItems = $coverflow.find('li');
  $coverflowItems.each(function(i) {
    console.log($(this));
    coverflowFaces[i] = new Photon.Face($(this)[0], shadeAmount);
  });
  $coverflowItems.eq(1).bind(transitionEndEvent, stopRenderTimer);
  setCoverTransforms();
}

function changeCover() {
  currentCover = currentCover < coverflowFaces.length - 1 ? currentCover + 1 : 0;
  setCoverTransforms(true);
}

function setCoverTransforms(animate) {
  if(!renderTimer && animate) {
    renderTimer = setInterval(renderCoverflow, 34);
  }
  for(var i = 0; i < coverflowFaces.length; i++) {
    var element = coverflowFaces[i].element;
    var offset = Math.abs(currentCover - i);
    var x = i == currentCover ? 0 : (150 + (100 * offset)) * (i < currentCover ? -1 : 1);
    var z = i == currentCover ? 0 : -200;

    var rotationY = i == currentCover ? 0 : (80 + (offset * -5)) * (i < currentCover ? 1 : -1);

    $(element).css(cssTransformProperty, 'translateX(' + x +'px) translateZ(' + z + 'px) rotateY(' + rotationY + 'deg)');
  }
}

function rotateCoverflow() {
  var newIndex = 0;
  if (currentCover < 5) {
    newIndex = currentCover+1;
  } else {
    newIndex = 0;
  }

  if(!renderTimer && newIndex != currentCover) {
    renderTimer = setInterval(renderCoverflow, 34);
    currentCover = newIndex;
  }
  for(var i = 0; i < coverflowFaces.length; i++) {
    var element = coverflowFaces[i].element;
    var offset = Math.abs(currentCover - i);
    var x = i == currentCover ? 0 : (150 + (100 * offset)) * (i < currentCover ? -1 : 1);
    var z = i == currentCover ? 0 : -200;
    var rotationY = i == currentCover ? 0 : (80 + (offset * -5)) * (i < currentCover ? 1 : -1);
    $(element).css(cssTransformProperty, 'translateX(' + x +'px) translateZ(' + z + 'px) rotateY(' + rotationY + 'deg)');
  }
}

function stopRenderTimer() {
  if(renderTimer) {
    clearInterval(renderTimer);
    renderTimer = null;
  }
}

function renderCoverflow() {
  for(var i = 0; i < coverflowFaces.length; i++) {
    coverflowFaces[i].render(light, true);
  }
}


function domToCss(property) {
  var css = property.replace(/([A-Z])/g, function (str, m1) {
    return '-' + m1.toLowerCase();
  }).replace(/^ms-/,'-ms-');
  return css;
}

function clamp(val, min, max) {
  if(val > max) return max;
  if(val < min) return min;
  return val;
}
