// pnltri.js / raw.github.com/jahting/pnltri.js/master/LICENSE
'use strict';var PNLTRI={REVISION:"1.4"};PNLTRI.Math={log2:function(a){return Math.log(a)/Math.LN2},random:Math.random,array_shuffle:function(a){for(var c=a.length-1;0<c;c--){var b=Math.floor(PNLTRI.Math.random()*(c+1)),d=a[c];a[c]=a[b];a[b]=d}return a},ptsCrossProd:function(a,c,b){return(c.x-a.x)*(b.y-a.y)-(c.y-a.y)*(b.x-a.x)}};PNLTRI.Math.EPSILON_P=Math.pow(2,-43);PNLTRI.Math.EPSILON_N=-PNLTRI.Math.EPSILON_P;PNLTRI.PolygonData=function(a){this.vertices=[];this.segments=[];this.idNextPolyChain=0;this.PolyLeftArr=[];this.monoSubPolyChains=[];this.triangles=[];if(a)for(var c=0,b=a.length;c<b;c++)this.addPolygonChain(a[c])};
PNLTRI.PolygonData.prototype={constructor:PNLTRI.PolygonData,getSegments:function(){return this.segments},getFirstSegment:function(){return this.segments[0]},getMonoSubPolys:function(){return this.monoSubPolyChains},getTriangles:function(){return this.triangles.concat()},nbPolyChains:function(){return this.idNextPolyChain},get_PolyLeftArr:function(){return this.PolyLeftArr.concat()},set_PolyLeft_wrong:function(a){this.PolyLeftArr[a]=!1},compare_pts_yx:function(a,c){var b=a.y-c.y;if(b<PNLTRI.Math.EPSILON_N)return-1;
if(b>PNLTRI.Math.EPSILON_P)return 1;b=a.x-c.x;return b<PNLTRI.Math.EPSILON_N?-1:b>PNLTRI.Math.EPSILON_P?1:0},isClockWise:function(a){var c=a,b=0;do b+=(c.vFrom.x-c.vTo.x)*(c.vFrom.y+c.vTo.y),c=c.snext;while(c!=a);return 0>b},appendVertexEntry:function(a,c){var b={id:this.vertices.length,x:a,y:c,outSegs:[]};this.vertices.push(b);return b},createSegmentEntry:function(a,c){return{chainId:this.idNextPolyChain,vFrom:a,vTo:c,upward:1==this.compare_pts_yx(c,a),sprev:null,snext:null,trLeft:null,trRight:null,
mprev:null,mnext:null,marked:!1}},appendSegmentEntry:function(a){this.segments.push(a);return a},addVertexChain:function(a){function c(a,b){return Math.abs(a.x-b.x)<PNLTRI.Math.EPSILON_P&&Math.abs(a.y-b.y)<PNLTRI.Math.EPSILON_P}for(var b=[],d,e,k,f=0;f<a.length;f++)d=this.appendVertexEntry(a[f].x,a[f].y),e=!0,k=b.length-1,0<=k&&c(d,b[k])&&(e=!1),e&&b.push(d);1<b.length&&c(b[b.length-1],b[0])&&b.pop();return b},addPolygonChain:function(a){a=this.addVertexChain(a);if(3>a.length)return console.log("Polygon has < 3 vertices!",
a),0;for(var c=this.segments.length,b,d,e,k=0;k<a.length-1;k++)b=this.createSegmentEntry(a[k],a[k+1]),e?(b.sprev=e,e.snext=b):d=b,e=b,this.appendSegmentEntry(b);b=this.createSegmentEntry(a[a.length-1],a[0]);b.sprev=e;e.snext=b;this.appendSegmentEntry(b);d.sprev=b;b.snext=d;this.PolyLeftArr[this.idNextPolyChain++]=!0;return this.segments.length-c},initMonoChains:function(){for(var a,c=0;c<this.segments.length;c++)a=this.segments[c],this.PolyLeftArr[a.chainId]?(a.mprev=a.sprev,a.mnext=a.snext,a.vFrom.outSegs.push({segOut:a,
vertTo:a.vTo})):(a=a.snext,a.mprev=a.snext,a.mnext=a.sprev,a.vFrom.outSegs.push({segOut:a,vertTo:this.segments[c].vFrom}))},createMonoSegment:function(a){this.appendSegmentEntry(a);a.vFrom.outSegs.push({segOut:a,vertTo:a.vTo});return a},newMonoChain:function(a){var c=this.monoSubPolyChains.length;this.monoSubPolyChains[c]=a;return c},splitPolygonChain:function(a,c,b,d){function e(a,b){for(var c,d,e=null,k=4,h=0;h<a.outSegs.length;h++){c=a.outSegs[h];var f=c.vertTo;d=f.x-a.x;var f=f.y-a.y,l=b.x-a.x,
t=b.y-a.y,v=(d*l+f*t)/Math.sqrt(d*d+f*f)/Math.sqrt(l*l+t*t);(d=0<=d*t-l*f?1-v:3+v)<k&&(k=d,e=c)}return e}var k,f;k=e(c,b);f=e(b,c);k=k.segOut;var l=f.segOut;f=this.createMonoSegment({vFrom:c,vTo:b,upward:!0,mprev:k.mprev,mnext:l});c=this.createMonoSegment({vFrom:b,vTo:c,upward:!1,mprev:l.mprev,mnext:k});k.mprev.mnext=f;l.mprev.mnext=c;k.mprev=c;l.mprev=f;b=this.monoSubPolyChains.length;d?(this.monoSubPolyChains[a]=f,this.monoSubPolyChains[b]=c):(this.monoSubPolyChains[a]=c,this.monoSubPolyChains[b]=
f);return b},unique_monotone_chains_max:function(){for(var a,c,b,d,e,k=[],f=0;f<this.monoSubPolyChains.length;f++){a=c=this.monoSubPolyChains[f];d=e=a.vFrom;a.marked=!0;a=a.mnext;for(var l=!1;(b=a.vFrom)!=d;){if(a.marked){l=!0;break}else a.marked=!0;1==this.compare_pts_yx(b,e)&&(e=b,c=a);a=a.mnext}l||k.push(c)}return k},normalize_monotone_chains:function(){this.monoSubPolyChains=this.unique_monotone_chains_max();return this.monoSubPolyChains.length},clearTriangles:function(){this.triangles=[]},addTriangle:function(a,
c,b){this.triangles.push([a.id,c.id,b.id])}};PNLTRI.EarClipTriangulator=function(a){this.polyData=a};
PNLTRI.EarClipTriangulator.prototype={constructor:PNLTRI.EarClipTriangulator,triangulate_polygon_no_holes:function(){var a=this.polyData,c=a.getFirstSegment(),b=c;if(a.isClockWise(c)){do b.mprev=b.snext,b=b.mnext=b.sprev;while(b!=c);a.set_PolyLeft_wrong(0)}else{do b.mprev=b.sprev,b=b.mnext=b.snext;while(b!=c)}for(c=a=c;a.mnext!=a.mprev;){a:{var b=a.mprev.vFrom.x,d=a.mprev.vFrom.y,e=a.vFrom.x,k=a.vFrom.y,f=a.mnext.vFrom.x,l=a.mnext.vFrom.y,n=f-e,p=l-k,q=b-f,u=d-l,g=e-b,m=k-d;if(PNLTRI.Math.EPSILON_P>
g*p-n*m)b=!1;else{for(var h=a.mprev.mprev,s=a.mnext;s!=h;){var s=s.mnext,r=s.vFrom.x,t=s.vFrom.y,v=r-b,w=t-d;if(0!=v||0!=w){var x=r-e,y=t-k;if(0!=x||0!=y)if(r-=f,t-=l,(0!=r||0!=t)&&n*y-p*x>=PNLTRI.Math.EPSILON_N&&g*w-m*v>=PNLTRI.Math.EPSILON_N&&q*t-u*r>=PNLTRI.Math.EPSILON_N){b=!1;break a}}}b=!0}}if(b)this.polyData.addTriangle(a.mprev.vFrom,a.vFrom,a.mnext.vFrom),a.mprev.mnext=a.mnext,a.mnext.mprev=a.mprev,c=a=a.mnext;else if(a=a.mnext,a==c)return!1}return!0}};PNLTRI.Trapezoid=function(a,c,b,d){this.vHigh=a?a:{x:Number.POSITIVE_INFINITY,y:Number.POSITIVE_INFINITY};this.vLow=c?c:{x:Number.NEGATIVE_INFINITY,y:Number.NEGATIVE_INFINITY};this.lseg=b;this.rseg=d;this.depth=-1;this.monoDone=!1};
PNLTRI.Trapezoid.prototype={constructor:PNLTRI.Trapezoid,clone:function(){var a=new PNLTRI.Trapezoid(this.vHigh,this.vLow,this.lseg,this.rseg);a.uL=this.uL;a.uR=this.uR;a.dL=this.dL;a.dR=this.dR;a.sink=this.sink;return a},splitOffLower:function(a){var c=this.clone();this.vLow=c.vHigh=a;this.dL=c;c.uL=this;this.dR=c.uR=null;c.dL&&(c.dL.uL=c);c.dR&&(c.dR.uR=c);return c}};PNLTRI.QsNode=function(a){this.trap=a;a.sink=this};PNLTRI.QsNode.prototype={constructor:PNLTRI.QsNode};
PNLTRI.QueryStructure=function(a){var c=new PNLTRI.Trapezoid(null,null,null,null);this.trapArray=[];this.appendTrapEntry(c);this.root=new PNLTRI.QsNode(c);if(a){for(var c=a.getSegments(),b=0;b<c.length;b++)c[b].rootFrom=c[b].rootTo=this.root,c[b].is_inserted=!1;this.compare_pts_yx=a.compare_pts_yx}else this.compare_pts_yx=PNLTRI.PolygonData.prototype.compare_pts_yx};
PNLTRI.QueryStructure.prototype={constructor:PNLTRI.QueryStructure,getRoot:function(){return this.root},appendTrapEntry:function(a){a.trapID=this.trapArray.length;this.trapArray.push(a)},cloneTrap:function(a){a=a.clone();this.appendTrapEntry(a);return a},splitNodeAtPoint:function(a,c,b){var d=a.trap;if(d.vHigh==c||d.vLow==c)return a;var e=d.splitOffLower(c);this.appendTrapEntry(e);a.yval=c;a.trap=null;a.right=new PNLTRI.QsNode(d);a.left=new PNLTRI.QsNode(e);return b?d.sink:e.sink},fpEqual:function(a,
c){return Math.abs(a-c)<PNLTRI.Math.EPSILON_P},is_left_of:function(a,c,b){b=a.vFrom.x-c.x;var d=a.vTo.x-c.x;if(Math.abs(a.vTo.y-c.y)<PNLTRI.Math.EPSILON_P)a=d,c=b;else if(Math.abs(a.vFrom.y-c.y)<PNLTRI.Math.EPSILON_P)a=b,c=d;else return a.upward?PNLTRI.Math.ptsCrossProd(a.vFrom,a.vTo,c):PNLTRI.Math.ptsCrossProd(a.vTo,a.vFrom,c);return Math.abs(a)<PNLTRI.Math.EPSILON_P?Math.abs(c)<PNLTRI.Math.EPSILON_P?0:c:a},ptNode:function(a,c,b){for(var d;b;)if(b.yval)d=a==b.yval?c:a,d=this.compare_pts_yx(d,b.yval),
b=-1==d?b.left:b.right;else if(b.seg)a==b.seg.vFrom||a==b.seg.vTo?this.fpEqual(a.y,c.y)?b=c.x<a.x?b.left:b.right:(d=this.is_left_of(b.seg,c,!1),b=0<d?b.left:0>d?b.right:a==b.seg.vFrom?b.right:b.left):(d=a,d=this.is_left_of(b.seg,d,!0),b=0<d?b.left:b.right);else return b.trap||console.log("ptNode: unknown type",b),b},add_segment:function(a){function c(){var a=g.uL||g.uR;a.dL&&a.dR?g==a.dL?(h.uL=null,a.dL=m):(m.uR=null,a.dR=h):(h.uL=null,h.uR=a,a.dR=h)}function b(a){g.vLow==u.vLow?(q?g.dL?(a.uL=m,m.dL=
a,h.dR=null):(a.uR=h,m.dL=null,h.dR=a):(a.uL=m,a.uR=h,m.dL=h.dR=a),m.dR=h.dL=null):(a.uL&&a.uR&&(a.uL==g?(a.usave=a.uR,a.uleft=!0):(a.usave=a.uL,a.uleft=!1)),a.uL=m,a.uR=h,m.dR=h.dL=a,m.dL=h.dR=null)}function d(){var b;g.vLow==u.vLow&&q?(g.dL.uL=m,g.dR.uR=h,m.dL=g.dL,h.dR=g.dR,b=m.dR=h.dL=null):(g.dL.uL=m,g.dR.uR=h,0<e.is_left_of(a,g.vLow,!0)?(b=g.dR,g.dR.uL=m,m.dL=g.dL,h.dR=null):(b=g.dL,g.dL.uR=h,h.dR=g.dR,m.dL=null),m.dR=h.dL=b);return b}var e=this,k,f,l,n,p,q;a.upward?(n=a.vFrom,k=a.vTo,p=a.rootFrom,
f=a.rootTo,q=a.sprev.is_inserted,l=a.snext.is_inserted):(n=a.vTo,k=a.vFrom,p=a.rootTo,f=a.rootFrom,q=a.snext.is_inserted,l=a.sprev.is_inserted);f=this.ptNode(k,n,f);l||(f=this.splitNodeAtPoint(f,k,!1));l=f.trap;if(l.uL||l.uR){f=this.ptNode(n,k,p);q||(f=this.splitNodeAtPoint(f,n,!0));var u=f.trap,g=l,m,h,s,r;for(k=this.trapArray.length+2;g;){if(0>--k){console.log("ERR add_segment: infinite loop",g,a,this);return}if(!g.dL&&!g.dR){console.log("ERR add_segment: missing successors",g,a,this);return}n=
g.sink;n.seg=a;n.trap=null;r&&r.rseg==g.rseg?(m=g,h=r,h.vLow=g.vLow,n.left=new PNLTRI.QsNode(m),n.right=r.sink):(s&&s.lseg==g.lseg?(h=g,m=s,m.vLow=g.vLow,n.left=s.sink):(m=g,h=this.cloneTrap(g),n.left=new PNLTRI.QsNode(m)),n.right=new PNLTRI.QsNode(h));g.uL&&g.uR?g.usave?(g.uleft?(h.uL=g.uR,h.uR=g.usave,h.uL.dL=h,h.uR.dR=h):(m.uR=g.uL,m.uL=g.usave,m.uL.dL=m,m.uR.dR=m),m.usave=h.usave=null):g.vHigh==l.vHigh?(h.uR.dR=h,m.uR=h.uL=null):h==g?(h.uL=h.uR,h.uR=null,h.uL.dL=h):(m.uR=m.uL,m.uL=null):c();g.dL&&
g.dR?n=d():(n=g.dL?g.dL:g.dR,b(n));m.rseg&&(m.rseg.trLeft=h);h.lseg&&(h.lseg.trRight=m);m.rseg=h.lseg=a;a.trLeft=m;a.trRight=h;g.vLow!=u.vLow?(s=m,r=h,g=n):g=null}a.is_inserted=!0}else console.log("ERR add_segment: missing trFirst.uX: ",l)},assignDepths:function(a){var c=[this.trapArray[0]],b=[],d,e,k=0;do{for(var f=1==k%2;d=c.pop();)-1==d.depth&&(d.depth=k,d.uL&&c.push(d.uL),d.uR&&c.push(d.uR),d.dL&&c.push(d.dL),d.dR&&c.push(d.dR),(e=d.lseg)&&-1==e.trLeft.depth&&b.push(e.trLeft),e=d.rseg)&&(-1==
e.trRight.depth&&b.push(e.trRight),e.upward!=f&&a.set_PolyLeft_wrong(e.chainId));c=b;b=[];k++}while(0<c.length)},find_first_inside:function(){for(var a,c=0,b=this.trapArray.length;c<b;c++)if(a=this.trapArray[c],1==a.depth%2&&!a.monoDone&&(!a.uL&&!a.uR||!a.dL&&!a.dR)&&a.lseg)return a;return null}};PNLTRI.Trapezoider=function(a){this.polyData=a;this.queryStructure=new PNLTRI.QueryStructure(this.polyData)};
PNLTRI.Trapezoider.prototype={constructor:PNLTRI.Trapezoider,find_first_inside:function(){return this.queryStructure.find_first_inside()},math_logstar_n:function(a){var c;for(c=0;1<=a;c++)a=PNLTRI.Math.log2(a);return c-1},math_NH:function(a,c){var b,d;b=0;for(d=a;b<c;b++)d=PNLTRI.Math.log2(d);return Math.ceil(1*a/d)-1},optimise_randomlist:function(a){var c=0,b=this.polyData.nbPolyChains();if(1!=b)for(var d=Array(b),e=a.concat(),k=0;k<e.length;k++){var f=e[k].chainId;d[f]?a[b++]=e[k]:(a[c++]=e[k],
d[f]=!0)}},trapezoide_polygon:function(){var a=this.polyData.getSegments().concat();PNLTRI.Math.array_shuffle(a);this.optimise_randomlist(a);var c=a.length,b=this.queryStructure,d,e,k,f=this.math_logstar_n(c);for(k=1;k<=f;k++){e=this.math_NH(c,k);for(d=this.math_NH(c,k-1);d<e;d++)b.add_segment(a[d]);for(d=e;d<c;d++)e=a[d],e.rootFrom=this.queryStructure.ptNode(e.vFrom,e.vTo,e.rootFrom),e.rootTo=this.queryStructure.ptNode(e.vTo,e.vFrom,e.rootTo)}for(d=this.math_NH(c,f);d<c;d++)b.add_segment(a[d]);b.assignDepths(this.polyData);
for(d=0;d<c;d++)a[d].trLeft=null,a[d].trRight=null}};PNLTRI.MonoSplitter=function(a){this.polyData=a;this.startTrap=this.trapezoider=null};
PNLTRI.MonoSplitter.prototype={constructor:PNLTRI.MonoSplitter,monotonate_trapezoids:function(){this.trapezoider=new PNLTRI.Trapezoider(this.polyData);this.trapezoider.trapezoide_polygon();this.startTrap=this.trapezoider.find_first_inside();this.polyData.initMonoChains();for(var a=this.startTrap;a;)this.alyTrap(this.polyData.newMonoChain(a.lseg),a,null,null,null),a=this.trapezoider.find_first_inside();return this.polyData.normalize_monotone_chains()},doSplit:function(a,c,b,d){return this.polyData.splitPolygonChain(a,
c,b,d)},alyTrap:function(a,c,b,d,e){function k(){var a;return(a=f.pop())?(l=a[0],n=a[1],p=a[2],q=a[3],!0):!1}var f=[],l,n,p,q,u;null==b&&(d=!0,c.uL?b=!0:c.dL?b=!1:(d=!1,b=c.uR?!0:!1));for(c&&f.push([c,b,d,a]);k();)if(!l.monoDone){l.monoDone=!0;if(!l.lseg||!l.rseg)return console.log("ERR alyTrap: lseg/rseg missing",l),f;n?p?(a=l.uL,c=l.uR,b=l.dL,d=l.dR):(a=l.uR,c=l.uL,b=l.dR,d=l.dL):p?(a=l.dL,c=l.dR,b=l.uL,d=l.uR):(a=l.dR,c=l.dL,b=l.uR,d=l.uL);if(c||d)u=this.doSplit(q,l.vLow,l.vHigh,p);d&&f.push([d,
n,!p,u]);c&&f.push([c,!n,!p,u]);b&&f.push([b,n,p,q]);b||d||a&&f.push([a,!n,p,q]);if(e)return f}return[]}};PNLTRI.MonoTriangulator=function(a){this.polyData=a};
PNLTRI.MonoTriangulator.prototype={constructor:PNLTRI.MonoTriangulator,triangulate_all_polygons:function(){var a=this.polyData.getMonoSubPolys();this.polyData.clearTriangles();for(var c=0;c<a.length;c++){var b=a[c],d=b.mprev,e=b.mnext;e.mnext==d?this.polyData.addTriangle(b.vFrom,e.vFrom,d.vFrom):this.triangulate_monotone_polygon(b)}},triangulate_monotone_polygon:function(a){var c=a.mnext;a=a.vFrom;var b=[c.vFrom],d=0,c=c.mnext,e=c.vFrom;if(e!=a){for(;e!=a||1<d;)if(0<d)if(0<PNLTRI.Math.ptsCrossProd(e,
b[d-1],b[d]))this.polyData.addTriangle(b[d-1],b[d],e),d--;else if(b[++d]=e,e==a)for(console.log("ERR uni-y-monotone: only concave angles left",b);1<d;)d--,this.polyData.addTriangle(b[d-1],b[d],b[d+1]);else c=c.mnext,e=c.vFrom;else b[++d]=e,c=c.mnext,e=c.vFrom;this.polyData.addTriangle(b[d-1],b[d],e)}}};PNLTRI.Triangulator=function(){this.lastPolyData=null};
PNLTRI.Triangulator.prototype={constructor:PNLTRI.Triangulator,clear_lastData:function(){this.lastPolyData=null},get_PolyLeftArr:function(){return this.lastPolyData?this.lastPolyData.get_PolyLeftArr():null},triangulate_polygon:function(a,c){this.clear_lastData();if(!a||0==a.length)return[];var b=new PNLTRI.PolygonData(a),d;d=c?!1:1==b.nbPolyChains();d&&(d=new PNLTRI.EarClipTriangulator(b),d=d.triangulate_polygon_no_holes());if(!d){(new PNLTRI.MonoSplitter(b)).monotonate_trapezoids();d=new PNLTRI.MonoTriangulator(b);
d.triangulate_all_polygons();d=b.getSegments();for(var e=0;e<d.length;e++)d[e].vFrom.outSegs=null}this.lastPolyData=b;return b.getTriangles()}};
