using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;


namespace Framefield.Core.ID49feaa7f_5aa3_4b56_bbd9_e5b05cb82c29
{
    public class Class_ValueToOrdinal : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            Value = 0
        }
        //<<< _inputids

        public static string ToOrdinal(int num)
        {
            if (num <= 0) return num.ToString();
        
            switch (num % 100)
            {
                case 11:
                case 12:
                case 13:
                    return num + "th";
            }
        
            switch (num % 10)
            {
                case 1:
                    return num + "st";
                case 2:
                    return num + "nd";
                case 3:
                    return num + "rd";
                default:
                    return num + "th";
            }
        
        }

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            //>>> _params
            var Value = inputs[(int)InputId.Value].Eval(context).Value;
            //<<< _params            
            
            context.Text = ToOrdinal((int)Value);
            return context;
        }
    }
}

