//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.IDf9a56d72_9461_429c_a29b_068ca0bad181
{
    public class Class_ScrambleImage : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            ShiftX = 1,
            ShiftY = 2,
            FrequencyAX = 3,
            FrequencyAY = 4,
            FrequencyBX = 5,
            FrequencyBY = 6,
            FrequencyCX = 7,
            FrequencyCY = 8,
            ProgressX = 9,
            ProgressY = 10,
            SubDivideRatioX = 11,
            SubDivideRatioY = 12,
            Image = 13,
            DisplaceStrengthX = 14,
            DisplaceStrengthY = 15
        }
        //<<< _inputids
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {

            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var ShiftX = inputs[(int)InputId.ShiftX].Eval(context).Value;
            var ShiftY = inputs[(int)InputId.ShiftY].Eval(context).Value;
            var Shift = new Vector2(ShiftX, ShiftY);
            var FrequencyAX = inputs[(int)InputId.FrequencyAX].Eval(context).Value;
            var FrequencyAY = inputs[(int)InputId.FrequencyAY].Eval(context).Value;
            var FrequencyA = new Vector2(FrequencyAX, FrequencyAY);
            var FrequencyBX = inputs[(int)InputId.FrequencyBX].Eval(context).Value;
            var FrequencyBY = inputs[(int)InputId.FrequencyBY].Eval(context).Value;
            var FrequencyB = new Vector2(FrequencyBX, FrequencyBY);
            var FrequencyCX = inputs[(int)InputId.FrequencyCX].Eval(context).Value;
            var FrequencyCY = inputs[(int)InputId.FrequencyCY].Eval(context).Value;
            var FrequencyC = new Vector2(FrequencyCX, FrequencyCY);
            var ProgressX = inputs[(int)InputId.ProgressX].Eval(context).Value;
            var ProgressY = inputs[(int)InputId.ProgressY].Eval(context).Value;
            var Progress = new Vector2(ProgressX, ProgressY);
            var SubDivideRatioX = inputs[(int)InputId.SubDivideRatioX].Eval(context).Value;
            var SubDivideRatioY = inputs[(int)InputId.SubDivideRatioY].Eval(context).Value;
            var SubDivideRatio = new Vector2(SubDivideRatioX, SubDivideRatioY);
            var Image = inputs[(int)InputId.Image].Eval(context).Image; if (Image == null) return context;
            var DisplaceStrengthX = inputs[(int)InputId.DisplaceStrengthX].Eval(context).Value;
            var DisplaceStrengthY = inputs[(int)InputId.DisplaceStrengthY].Eval(context).Value;
            var DisplaceStrength = new Vector2(DisplaceStrengthX, DisplaceStrengthY);
            //<<< _params

            return PrepareAndEvalOnChange(context, () => {
                ClearRenderTarget(context, new SharpDX.Color4(0, 0, 0, 0));

                //>>> _setup
                using (var ImageView = new ShaderResourceView(context.D3DDevice, Image))
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("Shift").AsVector().Set(new Vector2(ShiftX, ShiftY));
                    _effect.GetVariableByName("FrequencyA").AsVector().Set(new Vector2(FrequencyAX, FrequencyAY));
                    _effect.GetVariableByName("FrequencyB").AsVector().Set(new Vector2(FrequencyBX, FrequencyBY));
                    _effect.GetVariableByName("FrequencyC").AsVector().Set(new Vector2(FrequencyCX, FrequencyCY));
                    _effect.GetVariableByName("Progress").AsVector().Set(new Vector2(ProgressX, ProgressY));
                    _effect.GetVariableByName("SubDivideRatio").AsVector().Set(new Vector2(SubDivideRatioX, SubDivideRatioY));
                    _effect.GetVariableByName("Image").AsShaderResource().SetResource(ImageView);
                    _effect.GetVariableByName("DisplaceStrength").AsVector().Set(new Vector2(DisplaceStrengthX, DisplaceStrengthY));
                //<<< _setup

                Render(context);

                //>>> _cleanup
                }
                //<<< _cleanup
            });
        }

    }
}

