//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using
using System.Dynamic;
using System.IO;

namespace Framefield.Core.ID571cdc60_4819_46f4_a63c_895fbf9cac6a
{
    public class Class_LoadToMemory : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            FilePath = 0
        }
        //<<< _inputids

        public override void Dispose()
        {
            Utilities.DisposeObj(ref _rawResource);
        }

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) 
        {
            //>>> _params
            var FilePath = inputs[(int)InputId.FilePath].Eval(context).Text;
            //<<< _params

            if (FilePath == _lastFile)
                Changed = false;

            _lastFile = FilePath;

            if (Changed)
            {
                Dispose();
                if (File.Exists(FilePath))
                {
                    _rawResource = ResourceManager.ReadRaw(FilePath);
                }
                else
                {
                    Logger.Error(this, "file not found '{0}'", FilePath);
                }

                Changed = false;
            }

            if (_rawResource != null && _rawResource.Data != null)
            {
                dynamic obj = new ExpandoObject();
                obj.Data = _rawResource.Data;
                context.Dynamic = obj;
            }

            return context;
        }

        RawResource _rawResource;
        String _lastFile = String.Empty;
    }
}

