using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.DXGI;

namespace Framefield.Core.ID59c531a8_2d16_48b3_8641_ae8d9bce5223
{
    public class Class_Canvas : OperatorPart.Function
    {
        private bool BuildRenderTarget(OperatorPartContext context, int width, int height) {
            var resourceChanged = ResourceManager.ValidateRenderTargetResource(ref _renderTargetResource, OperatorPart, context.D3DDevice,
                                                                               width, height);
            if (resourceChanged) {
                Utilities.DisposeObj(ref _renderTargetView);
                _renderTargetView = new RenderTargetView(context.D3DDevice, _renderTargetResource.Texture);
            }
            return resourceChanged;
        }

        public override void Dispose() {
            ResourceManager.Dispose(_renderTargetResource);
            Utilities.DisposeObj(ref _renderTargetView);
        }

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            var width = (int) inputs[0].Eval(context).Value;
            var height = (int) inputs[1].Eval(context).Value;
            var ColorR = inputs[2].Eval(context).Value;
            var ColorG = inputs[3].Eval(context).Value;
            var ColorB = inputs[4].Eval(context).Value;
            var ColorA = inputs[5].Eval(context).Value;

            if (BuildRenderTarget(context, width, height))
                Changed = true;

            if (Changed) {
                context.D3DDevice.ImmediateContext.ClearRenderTargetView(_renderTargetView, new SharpDX.Color4(ColorR, ColorG, ColorB, ColorA));
                Changed = false;
            }

            context.Image = _renderTargetResource.Texture;

            return context;
        }

        Resource _renderTargetResource;
        RenderTargetView _renderTargetView;
    }

}


