//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using
using System.IO;

namespace Framefield.Core.IDb7d54d3e_099e_4e81_997e_fffc72001213
{
    public class Class_CacheRawFiles : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            StringList = 0
        }
        //<<< _inputids

        public override void Dispose()
        {
            foreach (var i in _rawResources)
                i.Dispose();
            _rawResources.Clear();
        }

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) 
        {
            //>>> params 
            dynamic StringList = inputs[(int)InputId.StringList].Eval(context).Dynamic;
            //<<< params

            if (StringList == null)
            {
                Logger.Info(this, "Can't convert incoming structure to Dynamic");
                return context;
            }
            
            if (Changed)
            {
                Changed = false;
                Dispose();
                try
                {
                    for (int i = 0; i < StringList.Count; ++i)
                    {
                        if (File.Exists(StringList[i]))
                        {
                            var r = ResourceManager.ReadRaw(StringList[i]);
                            if (r != null)
                                _rawResources.Add(r);
                        }
                    }
                }
                catch
                {
                }
            }

            return context;
        }

        List<RawResource> _rawResources = new List<RawResource>();
    }
}

