//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using
using SharpDX.Direct3D;
using Framefield.Core.OperatorPartTraits;
using Framefield.Core.Rendering;
using Buffer = SharpDX.Direct3D11.Buffer;

namespace Framefield.Core.ID6a6b89c5_0e1b_44fa_9fe8_23ca15cb94dc
{
    public class Class_BakeMeshes : FXSourceCodeFunction, IFXSceneSourceCode, IMeshSupplier
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Scene = 1,
            Value = 2
        }
        //<<< _inputids

        public Class_BakeMeshes()
        {
            _meshCollector = new MeshCollector(this);
        }

        public override void Dispose() 
        {
            Utilities.DisposeObj(ref _bakedMesh);
            base.Dispose();
        }

        public void AddMeshesTo(ICollection<Mesh> meshes)
        {
            UpdateMesh(new OperatorPartContext(), OperatorPart.Connections);
            if (_bakedMesh != null)
                meshes.Add(_bakedMesh);
        }

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            try
            {
                UpdateMesh(context, inputs);

                if (_bakedMesh.Vertices != null)
                {
                    // render stream output to screen or whatever target is set
                    context.Renderer.SetupEffect(context);
                    context.Renderer.Render(_bakedMesh, context);
                }
            }
            catch (Exception exception)
            {
                Logger.Error(this, "Load Effect error: {0}", exception.Message);
            }

            return context;
        }

        bool _firstEval = true;
        private void UpdateMesh(OperatorPartContext context, List<OperatorPart> inputs)
        {
            if (_firstEval) 
            {
                for (int i = 0; i < NumCodes(); ++i)
                    Compile(i);
                _firstEval = false;
                Changed = true;
            }


            if (!Changed && _bakedMesh.Vertices != null)
                return;

            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var Scene = inputs[(int)InputId.Scene];
            var Value = inputs[(int)InputId.Value].Eval(context).Value;
            //<<< _params

            if (Scene.Func.Changed || _bakedMesh.Vertices == null)
            {
                //Logger.Info(this, "collect meshes");
                _meshCollector.Collect(Scene);
                Scene.Func.Changed = false;
            }

            var inputMesh = _meshCollector.FirstMeshOrDefault;
            if (inputMesh == null)
            {
                Utilities.DisposeObj(ref _bakedMesh.Vertices);
                return;
            }

            _bakedMesh.NumTriangles = (from meshesWithtransform in _meshCollector.CollectedMeshes
                                  from mesh in meshesWithtransform.Value
                                  select mesh.NumTriangles).Sum();

            _bakedMesh.AttributesSize = inputMesh.AttributesSize;
            _bakedMesh.InputElements = inputMesh.InputElements;
            if (_bakedMesh.Vertices == null || _bakedMesh.Vertices.Description.SizeInBytes != inputMesh.Vertices.Description.SizeInBytes)
            {
                Utilities.DisposeObj(ref _bakedMesh.Vertices);
                _bakedMesh.Vertices = new Buffer(D3DDevice.Device, new BufferDescription()
                                                                  {
                                                                      BindFlags = BindFlags.StreamOutput | BindFlags.VertexBuffer,
                                                                      CpuAccessFlags = CpuAccessFlags.None,
                                                                      OptionFlags = ResourceOptionFlags.None,
                                                                      SizeInBytes = _bakedMesh.NumTriangles*_bakedMesh.AttributesSize*3,
                                                                      Usage = ResourceUsage.Default
                                                                  });
            }

            _effect.GetVariableByName("Value").AsScalar().Set(Value);
             var matrixEffectVariable = _effect.GetVariableByName("objectToWorldMatrix").AsMatrix();

            context.D3DDevice.ImmediateContext.OutputMerger.DepthStencilState = new DepthStencilState(context.D3DDevice,
                                                                                                        new DepthStencilStateDescription()
                                                                                                            {
                                                                                                                IsDepthEnabled = false,
                                                                                                                IsStencilEnabled = false
                                                                                                            });
            context.D3DDevice.ImmediateContext.InputAssembler.InputLayout = context.InputLayout;
            context.D3DDevice.ImmediateContext.InputAssembler.PrimitiveTopology = PrimitiveTopology.TriangleList;

            int streamOutputOffset = 0;

            foreach (var meshesWithTransform in _meshCollector.CollectedMeshes)
            {
                if (matrixEffectVariable != null && matrixEffectVariable.IsValid)
                {
                    matrixEffectVariable.SetMatrix(meshesWithTransform.Key);
                }

                foreach (var mesh in meshesWithTransform.Value)
                {
                    context.D3DDevice.ImmediateContext.StreamOutput.SetTargets(new StreamOutputBufferBinding(_bakedMesh.Vertices, streamOutputOffset));
                    context.D3DDevice.ImmediateContext.InputAssembler.SetVertexBuffers(0, new VertexBufferBinding(mesh.Vertices, inputMesh.AttributesSize, 0));
                    var technique = _effect.GetTechniqueByIndex(0);
                    technique.GetPassByIndex(0).Apply(context.D3DDevice.ImmediateContext);
                    context.D3DDevice.ImmediateContext.Draw(mesh.NumTriangles*3, 0);
                    streamOutputOffset += mesh.AttributesSize*mesh.NumTriangles*3;
                }
            }

            context.D3DDevice.ImmediateContext.StreamOutput.SetTargets(new StreamOutputBufferBinding(null, 0));

            Changed = false;
        }

        private Mesh _bakedMesh = new Mesh();
        private MeshCollector _meshCollector;
    }
}


