#ifndef _SMOKE_HLSL_
#define _SMOKE_HLSL_

// IQ
float noise(in float3 x)
{
  float3 p = floor(x);
  float3 f = frac(x);
  f = f * f * (3.0 - 2.0 * f);

  float2 uv = (p.xy + float2(37.0, 17.0) * p.z) + f.xy;
  float2 rg = TEXTURES[1].SampleBias(SAMPLERS[1], (uv+ 0.5)/256.0, -100.0 ).yx;
  return lerp(rg.x, rg.y, f.z);
}

float2 map(in float3 pos) 
{
  float den = 0.2 - pos.y;

    // invert space	
	//p = -7.0*p/dot(p,p);

    // twist space	
	//float co = cos(den - 0.25*iGlobalTime);
	//float si = sin(den - 0.25*iGlobalTime);
	//p.xz = mat2(co,-si,si,co)*p.xz;

    // smoke	
	float f;
	float3 q = pos;//                          - vec3(0.0,1.0,0.0)*iGlobalTime;;
    f  = 0.50000*noise( q ); q = q*2.02;// - vec3(0.0,1.0,0.0)*iGlobalTime;
    f += 0.25000*noise( q ); q = q*2.03;// - vec3(0.0,1.0,0.0)*iGlobalTime;
    f += 0.12500*noise( q ); q = q*2.01;// - vec3(0.0,1.0,0.0)*iGlobalTime;
    f += 0.06250*noise( q ); q = q*2.02;// - vec3(0.0,1.0,0.0)*iGlobalTime;
    f += 0.03125*noise( q );

	den = saturate(den + 4.0*f);
	
	
	
	return float2( den, den );
}

float3 shade(in float den)
{
  return lerp( float3(1.0,0.9,0.8), float3(0.4,0.15,0.1), den );// + 0.05*sin(p);
}

float2 mapFull(in float3 pos)
{
  return map(pos);
}
#endif