#ifndef _MARCHING_HLSL_
#define _MARCHING_HLSL_

#if 0
// Sphere tracing
float3 castRay(in float3 ro, in float3 rd, in float maxd)
{
  float precision = RAYCASTING_PRECISION;
  float h = precision * 5.0;
  float t = 0.0;
  float m = -1.0;

  uint i;
  for (i = 0; i < 150; ++i)
  {
    if (abs(h) < precision || t > maxd)
    {
      break;
    }

    t += h;
    float2 res = map(ro + rd * t);
    h = res.x;
    m = res.y;
  }
  if (t > maxd)
  {
    m = -1.0;
  }
  return float3(t, m, i/* * (t < maxd)*/);
}
#else

// Significally decreases fps on my scenes - need to research
#define NEW_LIMIT_STEP false

// Hybrid sphere tracing
float3 castRay(in float3 ro, in float3 rd, in float maxd, in float startT)
{
  float precision = RAYCASTING_PRECISION;
  // initial guess for t - just pick the start of the ray
  float t = startT;
  float m = -1.0;

  float d = map(ro + rd * t).x;
	float tNext, dNext;
  
  float last_t = t + 10000.0; // something far away from t0

  uint i;
  for (i = 0; i < MAX_RAY_STEPS; ++i)
  {
    // termination condition - iteration has converged to surface
    if (abs(last_t - t) < precision || t > maxd)
    {
      break;
    }

    tNext = t + d;
    float2 res = map(ro + rd * tNext);
	  dNext = res.x;
    m     = res.y;

    // NEW ALGORITHM
		// are we crossing the surface? (sign(d) != sign(dNext)).
		// im detecting this by dividing the two and checking
		// if the result is negative. the only reason i use a divide is because
		// ill reuse the division result later. i thought it would be unstable but
		// it seems to work fine!
		float dNext_over_d = dNext/d;
		if (NEW_LIMIT_STEP && dNext_over_d < 0.0)
		{
			// fit a line from (current t, current d) to (next t, next d),
			// and set t to the approximated intersection of the line with d=0
			
			// the human readable version
			// float grad = (dNext - d) / d;
			// d /= -grad;
			// steeper gradient means smaller step. this is analytically
			// correct (to a linear approximation of the surface)

			// optimised (confuscated) version
			d /= 1.0 - dNext_over_d;
			
			// re-evaluate at the partial step location
			tNext = t + d;
			//dNext = sign(d) * 0.00001; // use +/- epsilon as approximated dist?
      float2 res = map(ro + rd * tNext);
	    dNext = res.x;
      m     = res.y;

			// OPTION - terminate march after doing this correction step. perhaps
			// i'll visualise the error from this later
      //return float3(t, m, i);
		}
		// END OF NEW ALGORITHM
    
    last_t = t;
		t      = tNext;
		d      = dNext;
  }
  m = lerp(m, -1.0, max(sign(t - maxd - 0.00001), 0.0));
  /*if (t > maxd)
  {
    m = -1.0;
  }*/
  return float3(t, m, i/* * (t < maxd)*/);
}
#endif

#if 1
#define USE_FAST_NORMAL_APPROXIMATION 0

float3 calcNormal(in float3 pos)
{
  float3 eps = float3(NORMAL_EPS, 0.0, 0.0);

#if USE_FAST_NORMAL_APPROXIMATION	
  float d = map(pos + eps.xyy).x;
	return normalize(float3(map(pos + eps.xyy).x - d,
                          map(pos + eps.yxy).x - d,
                          map(pos + eps.yyx).x - d));
#else	
  float3 nor = float3(map(pos + eps.xyy).x - map(pos - eps.xyy).x,
                      map(pos + eps.yxy).x - map(pos - eps.yxy).x,
                      map(pos + eps.yyx).x - map(pos - eps.yyx).x);
  return normalize(nor);
#endif // USE_FAST_NORMAL_APPROXIMATION
}

float calcAO(in float3 pos, in float3 nor)
{
  float totao = 0.0;
  float sca = 1.0;
  for (float aoi = 0; aoi < 5.0; aoi += 1.0)
  {
    float hr = 0.01 + 0.05 * aoi;
    float3 aopos =  nor * hr + pos;
    float dd = map(aopos).x;
    totao += -(dd - hr) * sca;
    sca *= 0.75;
  }

  return saturate(1.0 - 4.0 * totao);
}

float shadow(in float3 ro, in float3 rd, float mint, float maxt)
{
  float res = 1.0;
  for (float t = mint; t < maxt; )
  {
#if USE_BB_OPTIMIZATION && USE_FULL_MAP_FOR_SHADOWS 
    float h = mapFull(ro + rd * t).x;
#else 
    float h = map(ro + rd * t).x;
#endif
    
    if (h < 0.001)
    {
      res = 0.0;
      break;
    }
    t += h;
    // Too slow
    //t += clamp(h, 0.02, 0.1);
  }
  return res;
}

float softShadow(in float3 ro, in float3 rd, in float mint, in float maxt, in float k)
{
  float res = 1.0;
  float t = mint;

  for (uint i = 0; i < SOFT_SHADOWS_MAXSTEPS; ++i)
  {
	  if (t >= maxt)
    {
      break;
    }
	  {
#if USE_BB_OPTIMIZATION && USE_FULL_MAP_FOR_SHADOWS 
      float h = mapFull(ro + rd * t).x;
#else 
      float h = map(ro + rd * t).x;
#endif
      res = min(res, k * h / t);
      // Constant step -- seams in shadows
      //t += SOFT_SHADOWS_STEP;
      // Optimal step
      // TODO: measure perfomance
      t += clamp(h, 0.02, 1.0);
	  }
  }
  return saturate(res);
}

float softShadowAdaptive(in float3 ro, in float3 rd, in float mint, in float maxt, in float k, in float depth)
{
  float res = 1.0;
  float t = mint;

  // FIXME: should depend on minimal geometry thickness (otherwise seams in shadows)
  const float step = min(depth / MAX_RAY_DISTANCE * 4.0 + 0.1, 0.5);
  // Fallback to hard shadows for distant pixels
  // FIXME: hard shadows are slower then soft
  //if (step >= 0.5)
  // return shadow(ro, rd, mint, maxt);

  for (uint i = 0; i < 100; ++i)
  {
	  if (t >= maxt)
    {
      break;
    }
	  {
      float h = map(ro + rd * t).x;
      res = min(res, k * h / t);
      t += step;
	  }
  }
  return saturate(res);
}

#endif // 1


#endif