import socket
import pickle
import serverLobby
import utils

class Server: 

	def __init__( self, port, maxPlayers, gameTime, host = "localhost" ):

		self.socket = socket.socket( socket.AF_INET, socket.SOCK_DGRAM )
		self.socket.setblocking( False )
		self.socket.bind( ( host, port ) )

		self.address_to_user = {}
		self.availableColors = self.generateAvailableColors( maxPlayers )
		self.maxPlayers = maxPlayers
		self.gameTime = gameTime

		self.openLobby()

	def openLobby( self ):
		self.lobby = serverLobby.ServerLobby( self )
		self.lobby.run()

	def openGame( self ):
		pass

	def generateAvailableColors( self, maxPlayers ):
		colors = utils.availableColors
		available = {}
		for x in range( 0, maxPlayers ):
			available[ colors.keys()[x] ] = colors.values()[x]
		return available

class Player: 

	def __init__( self, name, color ):
		self.name = name
		self.color = color
		self.ready = False

