if (typeof GameSocket === 'undefined') {
	var GameSocket = function(ip, port) {
		var socket,
			buffer = {},
			hasConnected = false,
			lastData = '',
			setBuffer = function(bfr) {
				buffer = bfr;
			},
			addToBuffer = function(key, data) {
				buffer[key] = data;
			},
			sendBuffer = function() {
				var key,
					data;
				if (socket.readyState == 1) {
					if (buffer.size() > 0) {
						data = JSON.stringify(buffer)
						socket.onsend();
						socket.send(data);
					}
				}
			},
			clone = function(newIp, newPort) {
				newIp = typeof newIp !== 'undefined' ? newIp : ip;
				newPort = typeof newPort !== 'undefined' ? newPort : port;
				var sock = new GameSocket(newIp, newPort),
					key;
				for (key in socket) {
					if (key !== 'binaryType' &&
						key !== 'bufferedAmount' &&
						key !== 'extensions' &&
						key !== 'readyState' &&
						key !== 'close' &&
						key !== 'send' && 
						key !== 'addEventListener' &&
						key !== 'removeEventListener' &&
						key !== 'size' &&
						key !== 'sendBuffer' && 
						key !== 'addToBuffer' &&
						key !== 'interval'
					) {
						sock[key] = socket[key];
					}
				}
				sock.setBuffer(buffer);
				sock.ip = newIp;
				return sock;
			};
		try {
			socket = new WebSocket('ws://' + ip + ':' + port);
			window.addListener('onbeforeunload', function() {
        		socket.onclose = function() {};
        		socket.close();
    		}, false);
    		socket.interval = setInterval(sendBuffer, 1000 / 30);
    		socket.setBuffer = sendBuffer;
    		socket.clone = clone;
			socket.hasConnected = hasConnected;
			socket.addToBuffer = addToBuffer;
			socket.sendBuffer = sendBuffer;
			socket.ip = ip;
			return socket;
		} catch(e) {
			console.log(e);
		}
	};
}