/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.opengl.shaders;

import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.test.opengl.shaders.Shader;
import org.lwjgl.test.opengl.shaders.ShadersTest;

final class ShaderFSH
extends Shader {
    final String vshFile;
    final String vshSource;
    final int vshID;
    final String fshFile;
    final String fshSource;
    final int fshID;
    final int programID;
    final int uniformLocation;

    ShaderFSH(String vshFile, String fshFile) {
        this.vshFile = vshFile;
        this.vshSource = ShaderFSH.getShaderText(vshFile);
        this.vshID = ARBShaderObjects.glCreateShaderObjectARB(35633);
        ARBShaderObjects.glShaderSourceARB(this.vshID, this.vshSource);
        ARBShaderObjects.glCompileShaderARB(this.vshID);
        ShaderFSH.printShaderObjectInfoLog(this.vshFile, this.vshID);
        if (ARBShaderObjects.glGetObjectParameteriARB(this.vshID, 35713) == 0) {
            ShadersTest.kill("A compilation error occured in a vertex shader.");
        }
        this.fshFile = fshFile;
        this.fshSource = ShaderFSH.getShaderText(fshFile);
        this.fshID = ARBShaderObjects.glCreateShaderObjectARB(35632);
        ARBShaderObjects.glShaderSourceARB(this.fshID, this.fshSource);
        ARBShaderObjects.glCompileShaderARB(this.fshID);
        ShaderFSH.printShaderObjectInfoLog(this.fshFile, this.fshID);
        if (ARBShaderObjects.glGetObjectParameteriARB(this.fshID, 35713) == 0) {
            ShadersTest.kill("A compilation error occured in a fragment shader.");
        }
        this.programID = ARBShaderObjects.glCreateProgramObjectARB();
        ARBShaderObjects.glAttachObjectARB(this.programID, this.vshID);
        ARBShaderObjects.glAttachObjectARB(this.programID, this.fshID);
        ARBShaderObjects.glLinkProgramARB(this.programID);
        ShaderFSH.printShaderProgramInfoLog(this.programID);
        if (ARBShaderObjects.glGetObjectParameteriARB(this.programID, 35714) == 0) {
            ShadersTest.kill("A linking error occured in a shader program.");
        }
        this.uniformLocation = ShaderFSH.getUniformLocation(this.programID, "UNIFORMS");
    }

    void render() {
        ARBShaderObjects.glUseProgramObjectARB(this.programID);
        ARBShaderObjects.glUniform4fARB(this.uniformLocation, ShadersTest.getSin(), (float)ShadersTest.getSpecularity() * 8.0f, (float)(-ShadersTest.getDisplayWidth()) * 0.5f, (float)(-ShadersTest.getDisplayHeight()) * 0.5f);
        ShadersTest.renderObject();
        ARBShaderObjects.glUseProgramObjectARB(0);
    }

    void cleanup() {
        ARBShaderObjects.glDetachObjectARB(this.programID, this.vshID);
        ARBShaderObjects.glDetachObjectARB(this.programID, this.fshID);
        ARBShaderObjects.glDeleteObjectARB(this.vshID);
        ARBShaderObjects.glDeleteObjectARB(this.fshID);
        ARBShaderObjects.glDeleteObjectARB(this.programID);
    }
}

