/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.opencl.gl;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.PointerBuffer;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opencl.CL;
import org.lwjgl.opencl.CL10;
import org.lwjgl.opencl.CL10GL;
import org.lwjgl.opencl.CLCapabilities;
import org.lwjgl.opencl.CLCommandQueue;
import org.lwjgl.opencl.CLContext;
import org.lwjgl.opencl.CLContextCallback;
import org.lwjgl.opencl.CLDevice;
import org.lwjgl.opencl.CLDeviceCapabilities;
import org.lwjgl.opencl.CLEvent;
import org.lwjgl.opencl.CLKernel;
import org.lwjgl.opencl.CLMem;
import org.lwjgl.opencl.CLPlatform;
import org.lwjgl.opencl.CLProgram;
import org.lwjgl.opencl.KHRGLEvent;
import org.lwjgl.opencl.api.Filter;
import org.lwjgl.opengl.AMDDebugOutput;
import org.lwjgl.opengl.AMDDebugOutputCallback;
import org.lwjgl.opengl.ARBCLEvent;
import org.lwjgl.opengl.ARBDebugOutput;
import org.lwjgl.opengl.ARBDebugOutputCallback;
import org.lwjgl.opengl.ARBSync;
import org.lwjgl.opengl.ContextAttribs;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.Drawable;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.opengl.GLSync;
import org.lwjgl.opengl.PixelFormat;
import org.lwjgl.util.Color;
import org.lwjgl.util.ReadableColor;

public class DemoFractal {
    private static final int MAX_PARALLELISM_LEVEL = 8;
    private static final int COLOR_MAP_SIZE = 256;
    private Set<String> params;
    private CLContext clContext;
    private CLCommandQueue[] queues;
    private CLKernel[] kernels;
    private CLProgram[] programs;
    private CLMem[] glBuffers;
    private IntBuffer glIDs;
    private boolean useTextures;
    private int dlist;
    private int vsh;
    private int fsh;
    private int program;
    private CLMem[] colorMap;
    private final PointerBuffer kernel2DGlobalWorkSize;
    private int maxIterations = 500;
    private int width = 512;
    private int height = 512;
    private double minX = -2.0;
    private double minY = -1.2f;
    private double maxX = 0.6f;
    private double maxY = 1.3f;
    private boolean dragging;
    private double dragX;
    private double dragY;
    private double dragMinX;
    private double dragMinY;
    private double dragMaxX;
    private double dragMaxY;
    private int mouseX;
    private int mouseY;
    private int slices;
    private boolean drawSeparator;
    private boolean doublePrecision = true;
    private boolean buffersInitialized;
    private boolean rebuild;
    private boolean run = true;
    private final PointerBuffer syncBuffer = BufferUtils.createPointerBuffer(1);
    private boolean syncGLtoCL;
    private CLEvent[] clEvents;
    private GLSync[] clSyncs;
    private boolean syncCLtoGL;
    private GLSync glSync;
    private CLEvent glEvent;

    public DemoFractal(String[] args) {
        this.params = new HashSet<String>();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.charAt(0) != '-' && arg.charAt(0) != '/') {
                throw new IllegalArgumentException("Invalid command-line argument: " + args[i]);
            }
            String param = arg.substring(1);
            if ("forcePBO".equalsIgnoreCase(param)) {
                this.params.add("forcePBO");
                continue;
            }
            if ("forceCPU".equalsIgnoreCase(param)) {
                this.params.add("forceCPU");
                continue;
            }
            if ("debugGL".equalsIgnoreCase(param)) {
                this.params.add("debugGL");
                continue;
            }
            if ("iterations".equalsIgnoreCase(param)) {
                if (args.length < i + 1 + 1) {
                    throw new IllegalArgumentException("Invalid iterations argument specified.");
                }
                try {
                    this.maxIterations = Integer.parseInt(args[++i]);
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Invalid number of iterations specified.");
                }
            }
            if (!"res".equalsIgnoreCase(param)) continue;
            if (args.length < i + 2 + 1) {
                throw new IllegalArgumentException("Invalid res argument specified.");
            }
            try {
                this.width = Integer.parseInt(args[++i]);
                this.height = Integer.parseInt(args[++i]);
                if (this.width >= 1 && this.height >= 1) continue;
                throw new IllegalArgumentException("Invalid res dimensions specified.");
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid res dimensions specified.");
            }
        }
        this.kernel2DGlobalWorkSize = BufferUtils.createPointerBuffer(2);
    }

    public static void main(String[] args) {
        DemoFractal demo = new DemoFractal(args);
        demo.init();
        demo.run();
    }

    public void init() {
        try {
            CL.create();
            Display.setDisplayMode(new DisplayMode(this.width, this.height));
            Display.setTitle("OpenCL Fractal Demo");
            Display.setSwapInterval(0);
            Display.create(new PixelFormat(), new ContextAttribs().withDebug(this.params.contains("debugGL")));
        }
        catch (LWJGLException e) {
            throw new RuntimeException(e);
        }
        try {
            this.initCL(Display.getDrawable());
        }
        catch (Exception e) {
            if (this.clContext != null) {
                CL10.clReleaseContext(this.clContext);
            }
            Display.destroy();
            throw new RuntimeException(e);
        }
        GL11.glDisable(2929);
        GL11.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        DemoFractal.initView(Display.getDisplayMode().getWidth(), Display.getDisplayMode().getHeight());
        this.initGLObjects();
        GL11.glFinish();
        this.setKernelConstants();
    }

    private void initCL(Drawable drawable) throws Exception {
        List<CLPlatform> platforms = CLPlatform.getPlatforms();
        if (platforms == null) {
            throw new RuntimeException("No OpenCL platforms found.");
        }
        CLPlatform platform = platforms.get(0);
        Filter<CLDevice> glSharingFilter = new Filter<CLDevice>(){

            @Override
            public boolean accept(CLDevice device) {
                CLDeviceCapabilities caps = CLCapabilities.getDeviceCapabilities(device);
                return caps.CL_KHR_gl_sharing;
            }
        };
        int device_type = this.params.contains("forceCPU") ? 2 : 4;
        List<CLDevice> devices = platform.getDevices(device_type, glSharingFilter);
        if (devices == null && (devices = platform.getDevices(device_type = 2, glSharingFilter)) == null) {
            throw new RuntimeException("No OpenCL devices found with KHR_gl_sharing support.");
        }
        this.clContext = CLContext.create(platform, devices, new CLContextCallback(){

            protected void handleMessage(String errinfo, ByteBuffer private_info) {
                System.out.println("[CONTEXT MESSAGE] " + errinfo);
            }
        }, drawable, null);
        this.slices = Math.min(devices.size(), 8);
        this.queues = new CLCommandQueue[this.slices];
        this.kernels = new CLKernel[this.slices];
        this.colorMap = new CLMem[this.slices];
        for (int i = 0; i < this.slices; ++i) {
            this.colorMap[i] = CL10.clCreateBuffer(this.clContext, 4L, 256L, null);
            this.colorMap[i].checkValid();
            this.queues[i] = CL10.clCreateCommandQueue(this.clContext, devices.get(i), 2L, null);
            this.queues[i].checkValid();
            ByteBuffer colorMapBuffer = CL10.clEnqueueMapBuffer(this.queues[i], this.colorMap[i], 1, 2L, 0L, 256L, null, null, null);
            DemoFractal.initColorMap(colorMapBuffer.asIntBuffer(), 32, Color.BLUE, Color.GREEN, Color.RED);
            CL10.clEnqueueUnmapMemObject(this.queues[i], this.colorMap[i], colorMapBuffer, null, null);
        }
        boolean all64bit = true;
        for (CLDevice device : devices) {
            if (DemoFractal.isDoubleFPAvailable(device)) continue;
            all64bit = false;
            break;
        }
        this.programs = new CLProgram[all64bit ? 1 : this.slices];
        ContextCapabilities caps = GLContext.getCapabilities();
        if (!caps.OpenGL20) {
            throw new RuntimeException("OpenGL 2.0 is required to run this demo.");
        }
        if (device_type == 2 && !caps.OpenGL21) {
            throw new RuntimeException("OpenGL 2.1 is required to run this demo.");
        }
        if (this.params.contains("debugGL")) {
            if (caps.GL_ARB_debug_output) {
                ARBDebugOutput.glDebugMessageCallbackARB(new ARBDebugOutputCallback());
            } else if (caps.GL_AMD_debug_output) {
                AMDDebugOutput.glDebugMessageCallbackAMD(new AMDDebugOutputCallback());
            }
        }
        if (device_type == 4) {
            System.out.println("OpenCL Device Type: GPU (Use -forceCPU to use CPU)");
        } else {
            System.out.println("OpenCL Device Type: CPU");
        }
        for (int i = 0; i < devices.size(); ++i) {
            System.out.println("OpenCL Device #" + (i + 1) + " supports KHR_gl_event = " + CLCapabilities.getDeviceCapabilities((CLDevice)devices.get((int)i)).CL_KHR_gl_event);
        }
        System.out.println("\nMax Iterations: " + this.maxIterations + " (Use -iterations <count> to change)");
        System.out.println("Display resolution: " + this.width + "x" + this.height + " (Use -res <width> <height> to change)");
        System.out.println("\nOpenGL caps.GL_ARB_sync = " + caps.GL_ARB_sync);
        System.out.println("OpenGL caps.GL_ARB_cl_event = " + caps.GL_ARB_cl_event);
        boolean bl = this.useTextures = device_type == 4 && (!caps.OpenGL21 || !this.params.contains("forcePBO"));
        if (this.useTextures) {
            System.out.println("\nCL/GL Sharing method: TEXTURES (use -forcePBO to use PBO + DrawPixels)");
            System.out.println("Rendering method: Shader on a fullscreen quad");
        } else {
            System.out.println("\nCL/GL Sharing method: PIXEL BUFFER OBJECTS");
            System.out.println("Rendering method: DrawPixels");
        }
        this.buildPrograms();
        this.syncGLtoCL = caps.GL_ARB_cl_event;
        if (this.syncGLtoCL) {
            this.clEvents = new CLEvent[this.slices];
            this.clSyncs = new GLSync[this.slices];
            System.out.println("\nGL to CL sync: Using OpenCL events");
        } else {
            System.out.println("\nGL to CL sync: Using clFinish");
        }
        boolean bl2 = this.syncCLtoGL = caps.OpenGL32 || caps.GL_ARB_sync;
        if (this.syncCLtoGL) {
            for (CLDevice device : devices) {
                if (CLCapabilities.getDeviceCapabilities((CLDevice)device).CL_KHR_gl_event) continue;
                this.syncCLtoGL = false;
                break;
            }
        }
        if (this.syncCLtoGL) {
            System.out.println("CL to GL sync: Using OpenGL sync objects");
        } else {
            System.out.println("CL to GL sync: Using glFinish");
        }
        if (this.useTextures) {
            this.dlist = GL11.glGenLists(1);
            GL11.glNewList(this.dlist, 4864);
            GL11.glBegin(7);
            GL11.glTexCoord2f(0.0f, 0.0f);
            GL11.glVertex2f(0.0f, 0.0f);
            GL11.glTexCoord2f(0.0f, 1.0f);
            GL11.glVertex2i(0, this.height);
            GL11.glTexCoord2f(1.0f, 1.0f);
            GL11.glVertex2f(this.width, this.height);
            GL11.glTexCoord2f(1.0f, 0.0f);
            GL11.glVertex2f(this.width, 0.0f);
            GL11.glEnd();
            GL11.glEndList();
            this.vsh = GL20.glCreateShader(35633);
            GL20.glShaderSource(this.vsh, "varying vec2 texCoord;\n\nvoid main(void) {\n\tgl_Position = ftransform();\n\ttexCoord = gl_MultiTexCoord0.xy;\n}");
            GL20.glCompileShader(this.vsh);
            this.fsh = GL20.glCreateShader(35632);
            GL20.glShaderSource(this.fsh, "uniform sampler2D mandelbrot;\n\nvarying vec2 texCoord;\n\nvoid main(void) {\n\tgl_FragColor = texture2D(mandelbrot, texCoord);}");
            GL20.glCompileShader(this.fsh);
            this.program = GL20.glCreateProgram();
            GL20.glAttachShader(this.program, this.vsh);
            GL20.glAttachShader(this.program, this.fsh);
            GL20.glLinkProgram(this.program);
            GL20.glUseProgram(this.program);
            GL20.glUniform1i(GL20.glGetUniformLocation(this.program, "mandelbrot"), 0);
        }
        System.out.println("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildPrograms() {
        int i;
        if (this.programs[0] != null) {
            for (CLProgram program : this.programs) {
                CL10.clReleaseProgram(program);
            }
        }
        try {
            this.createPrograms();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (i = 0; i < this.programs.length; ++i) {
            CLDevice device = this.queues[i].getCLDevice();
            StringBuilder options = new StringBuilder(this.useTextures ? "-D USE_TEXTURE" : "");
            CLDeviceCapabilities caps = CLCapabilities.getDeviceCapabilities(device);
            if (this.doublePrecision && DemoFractal.isDoubleFPAvailable(device)) {
                options.append(" -D DOUBLE_FP");
                if (!caps.CL_KHR_fp64 && caps.CL_AMD_fp64) {
                    options.append(" -D AMD_FP");
                }
            }
            System.out.println("\nOpenCL COMPILER OPTIONS: " + options);
            try {
                CL10.clBuildProgram(this.programs[i], device, (CharSequence)options, null);
                continue;
            }
            finally {
                System.out.println("BUILD LOG: " + this.programs[i].getBuildInfoString(device, 4483));
            }
        }
        this.rebuild = false;
        for (i = 0; i < this.kernels.length; ++i) {
            this.kernels[i] = CL10.clCreateKernel(this.programs[Math.min(i, this.programs.length)], "mandelbrot", null);
        }
    }

    private void initGLObjects() {
        if (this.glBuffers == null) {
            this.glBuffers = new CLMem[this.slices];
            this.glIDs = BufferUtils.createIntBuffer(this.slices);
        } else {
            for (CLMem mem : this.glBuffers) {
                CL10.clReleaseMemObject(mem);
            }
            if (this.useTextures) {
                GL11.glDeleteTextures(this.glIDs);
            } else {
                GL15.glDeleteBuffers(this.glIDs);
            }
        }
        if (this.useTextures) {
            GL11.glGenTextures(this.glIDs);
            for (int i = 0; i < this.slices; ++i) {
                GL11.glBindTexture(3553, this.glIDs.get(i));
                GL11.glTexImage2D(3553, 0, 6408, this.width / this.slices, this.height, 0, 6408, 5121, (ByteBuffer)null);
                GL11.glTexParameteri(3553, 10241, 9728);
                GL11.glTexParameteri(3553, 10240, 9728);
                this.glBuffers[i] = CL10GL.clCreateFromGLTexture2D(this.clContext, 2L, 3553, 0, this.glIDs.get(i), null);
            }
            GL11.glBindTexture(3553, 0);
        } else {
            GL15.glGenBuffers(this.glIDs);
            for (int i = 0; i < this.slices; ++i) {
                GL15.glBindBuffer(35052, this.glIDs.get(i));
                GL15.glBufferData(35052, this.width * this.height * 4 / this.slices, 35040);
                this.glBuffers[i] = CL10GL.clCreateFromGLBuffer(this.clContext, 2L, this.glIDs.get(i), null);
            }
            GL15.glBindBuffer(35052, 0);
        }
        this.buffersInitialized = true;
    }

    private void setKernelConstants() {
        for (int i = 0; i < this.slices; ++i) {
            this.kernels[i].setArg(6, this.glBuffers[i]).setArg(7, this.colorMap[i]).setArg(8, 256).setArg(9, this.maxIterations);
        }
    }

    private void run() {
        long startTime = System.currentTimeMillis() + 5000L;
        long fps = 0L;
        while (this.run) {
            if (!Display.isVisible()) {
                Thread.yield();
            }
            this.handleIO();
            this.display();
            Display.update();
            if (Display.isCloseRequested()) break;
            if (startTime > System.currentTimeMillis()) {
                ++fps;
                continue;
            }
            long timeUsed = 5000L + (startTime - System.currentTimeMillis());
            startTime = System.currentTimeMillis() + 5000L;
            System.out.println(fps + " frames in 5 seconds = " + (float)fps / ((float)timeUsed / 1000.0f));
            fps = 0L;
        }
        CL10.clReleaseContext(this.clContext);
        if (this.useTextures) {
            GL20.glDeleteProgram(this.program);
            GL20.glDeleteShader(this.fsh);
            GL20.glDeleteShader(this.vsh);
            GL11.glDeleteLists(this.dlist, 1);
        }
        CL.destroy();
        Display.destroy();
    }

    public void display() {
        if (this.syncCLtoGL && this.glEvent != null) {
            for (CLCommandQueue queue : this.queues) {
                CL10.clEnqueueWaitForEvents(queue, this.glEvent);
            }
        } else {
            GL11.glFinish();
        }
        if (!this.buffersInitialized) {
            this.initGLObjects();
            this.setKernelConstants();
        }
        if (this.rebuild) {
            this.buildPrograms();
            this.setKernelConstants();
        }
        this.compute(this.doublePrecision);
        this.render();
    }

    private void compute(boolean is64bit) {
        int i;
        int sliceWidth = (int)((float)this.width / (float)this.slices);
        double rangeX = (this.maxX - this.minX) / (double)this.slices;
        double rangeY = this.maxY - this.minY;
        this.kernel2DGlobalWorkSize.put(0, sliceWidth).put(1, this.height);
        for (i = 0; i < this.slices; ++i) {
            this.kernels[i].setArg(0, sliceWidth).setArg(1, this.height);
            if (!is64bit || !DemoFractal.isDoubleFPAvailable(this.queues[i].getCLDevice())) {
                this.kernels[i].setArg(2, (float)(this.minX + rangeX * (double)i)).setArg(3, (float)this.minY).setArg(4, (float)rangeX).setArg(5, (float)rangeY);
            } else {
                this.kernels[i].setArg(2, this.minX + rangeX * (double)i).setArg(3, this.minY).setArg(4, rangeX).setArg(5, rangeY);
            }
            CL10GL.clEnqueueAcquireGLObjects(this.queues[i], this.glBuffers[i], null, null);
            CL10.clEnqueueNDRangeKernel(this.queues[i], this.kernels[i], 2, null, this.kernel2DGlobalWorkSize, null, null, null);
            CL10GL.clEnqueueReleaseGLObjects(this.queues[i], this.glBuffers[i], null, this.syncGLtoCL ? this.syncBuffer : null);
            if (!this.syncGLtoCL) continue;
            this.clEvents[i] = this.queues[i].getCLEvent(this.syncBuffer.get(0));
            this.clSyncs[i] = ARBCLEvent.glCreateSyncFromCLeventARB((CLContext)this.queues[i].getParent(), this.clEvents[i], 0);
        }
        if (!this.syncGLtoCL) {
            for (i = 0; i < this.slices; ++i) {
                CL10.clFinish(this.queues[i]);
            }
        }
    }

    private void render() {
        GL11.glClear(16384);
        if (this.syncGLtoCL) {
            for (int i = 0; i < this.slices; ++i) {
                ARBSync.glWaitSync(this.clSyncs[i], 0, 0L);
            }
        }
        int sliceWidth = this.width / this.slices;
        if (this.useTextures) {
            for (int i = 0; i < this.slices; ++i) {
                int seperatorOffset = this.drawSeparator ? i : 0;
                GL11.glBindTexture(3553, this.glIDs.get(i));
                GL11.glCallList(this.dlist);
            }
        } else {
            for (int i = 0; i < this.slices; ++i) {
                int seperatorOffset = this.drawSeparator ? i : 0;
                GL15.glBindBuffer(35052, this.glIDs.get(i));
                GL11.glRasterPos2i(sliceWidth * i + seperatorOffset, 0);
                GL11.glDrawPixels(sliceWidth, this.height, 6408, 5121, 0L);
            }
            GL15.glBindBuffer(35052, 0);
        }
        if (this.syncCLtoGL) {
            this.glSync = ARBSync.glFenceSync(37143, 0);
            this.glEvent = KHRGLEvent.clCreateEventFromGLsyncKHR(this.clContext, this.glSync, null);
        }
    }

    private void handleIO() {
        if (Keyboard.getNumKeyboardEvents() != 0) {
            while (Keyboard.next()) {
                if (Keyboard.getEventKeyState()) continue;
                int key = Keyboard.getEventKey();
                if (2 <= key && key <= 9) {
                    int number = key - 2 + 1;
                    this.slices = Math.min(number, Math.min(this.queues.length, 8));
                    System.out.println("NEW PARALLELISM LEVEL: " + this.slices);
                    this.buffersInitialized = false;
                    continue;
                }
                switch (Keyboard.getEventKey()) {
                    case 57: {
                        this.drawSeparator = !this.drawSeparator;
                        System.out.println("SEPARATOR DRAWING IS NOW: " + (this.drawSeparator ? "ON" : "OFF"));
                        break;
                    }
                    case 32: {
                        this.doublePrecision = !this.doublePrecision;
                        System.out.println("DOUBLE PRECISION IS NOW: " + (this.doublePrecision ? "ON" : "OFF"));
                        this.rebuild = true;
                        break;
                    }
                    case 199: {
                        this.minX = -2.0;
                        this.minY = -1.2f;
                        this.maxX = 0.6f;
                        this.maxY = 1.3f;
                        break;
                    }
                    case 1: {
                        this.run = false;
                    }
                }
            }
        }
        while (Mouse.next()) {
            int eventBtn = Mouse.getEventButton();
            int x = Mouse.getX();
            int y = Mouse.getY();
            if (Mouse.isButtonDown(0) && (x != this.mouseX || y != this.mouseY)) {
                if (!this.dragging) {
                    this.dragging = true;
                    this.dragX = this.mouseX;
                    this.dragY = this.mouseY;
                    this.dragMinX = this.minX;
                    this.dragMinY = this.minY;
                    this.dragMaxX = this.maxX;
                    this.dragMaxY = this.maxY;
                }
                double offsetX = ((double)x - this.dragX) * (this.maxX - this.minX) / (double)this.width;
                double offsetY = ((double)y - this.dragY) * (this.maxY - this.minY) / (double)this.height;
                this.minX = this.dragMinX - offsetX;
                this.minY = this.dragMinY - offsetY;
                this.maxX = this.dragMaxX - offsetX;
                this.maxY = this.dragMaxY - offsetY;
            } else {
                int dwheel;
                if (this.dragging) {
                    this.dragging = false;
                }
                if (eventBtn == -1 && (dwheel = Mouse.getEventDWheel()) != 0) {
                    double scaleFactor = Keyboard.isKeyDown(29) || Keyboard.isKeyDown(157) ? 0.25 : 0.05;
                    double scale = dwheel > 0 ? scaleFactor : -scaleFactor;
                    double deltaX = scale * (this.maxX - this.minX);
                    double deltaY = scale * (this.maxY - this.minY);
                    double offsetX = ((double)x / (double)this.width - 0.5) * deltaX * 2.0;
                    double offsetY = ((double)y / (double)this.height - 0.5) * deltaY * 2.0;
                    this.minX += deltaX + offsetX;
                    this.minY += deltaY - offsetY;
                    this.maxX += -deltaX + offsetX;
                    this.maxY += -deltaY - offsetY;
                }
            }
            this.mouseX = x;
            this.mouseY = y;
        }
    }

    private static boolean isDoubleFPAvailable(CLDevice device) {
        CLDeviceCapabilities caps = CLCapabilities.getDeviceCapabilities(device);
        return caps.CL_KHR_fp64 || caps.CL_AMD_fp64;
    }

    private void createPrograms() throws IOException {
        String source = this.getProgramSource("org/lwjgl/test/opencl/gl/Mandelbrot.cl");
        for (int i = 0; i < this.programs.length; ++i) {
            this.programs[i] = CL10.clCreateProgramWithSource(this.clContext, source, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getProgramSource(String file) throws IOException {
        InputStream source = null;
        URL sourceURL = Thread.currentThread().getContextClassLoader().getResource(file);
        if (sourceURL != null) {
            source = sourceURL.openStream();
        }
        if (source == null) {
            source = new FileInputStream("src/java/" + file);
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(source));
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                sb.append(line).append("\n");
            }
        }
        finally {
            source.close();
        }
        return sb.toString();
    }

    private static void initColorMap(IntBuffer colorMap, int stepSize, ReadableColor ... colors) {
        for (int n = 0; n < colors.length - 1; ++n) {
            ReadableColor color = colors[n];
            int r0 = color.getRed();
            int g0 = color.getGreen();
            int b0 = color.getBlue();
            color = colors[n + 1];
            int r1 = color.getRed();
            int g1 = color.getGreen();
            int b1 = color.getBlue();
            int deltaR = r1 - r0;
            int deltaG = g1 - g0;
            int deltaB = b1 - b0;
            for (int step = 0; step < stepSize; ++step) {
                float alpha = (float)step / (float)(stepSize - 1);
                int r = (int)((float)r0 + alpha * (float)deltaR);
                int g = (int)((float)g0 + alpha * (float)deltaG);
                int b = (int)((float)b0 + alpha * (float)deltaB);
                colorMap.put(r << 0 | g << 8 | b << 16);
            }
        }
    }

    private static void initView(int width, int height) {
        GL11.glViewport(0, 0, width, height);
        GL11.glMatrixMode(5888);
        GL11.glLoadIdentity();
        GL11.glMatrixMode(5889);
        GL11.glLoadIdentity();
        GL11.glOrtho(0.0, width, 0.0, height, 0.0, 1.0);
    }
}

