/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.openal;

import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.AL10;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;
import org.lwjgl.test.openal.BasicTest;
import org.lwjgl.util.WaveData;
import org.lwjgl.util.glu.GLU;

public class PositionTest
extends BasicTest {
    private GLUT glut;
    public static final int WINDOW_WIDTH = 640;
    public static final int WINDOW_HEIGHT = 480;
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    private boolean finished;
    private boolean pauseMode;
    private IntBuffer soundBuffers = BufferUtils.createIntBuffer(3);
    private IntBuffer soundSources = BufferUtils.createIntBuffer(3);
    private FloatBuffer listenerPosition = this.createFloatBuffer(new float[]{0.0f, 0.0f, 0.0f});
    private FloatBuffer listenerVelocity = this.createFloatBuffer(new float[]{0.0f, 0.0f, 0.0f});
    private FloatBuffer listenerOrientation = this.createFloatBuffer(new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f});
    private FloatBuffer leftPosition = this.createFloatBuffer(new float[]{-2.0f, 0.0f, 0.0f});
    private FloatBuffer leftVelocity = this.createFloatBuffer(new float[]{0.0f, 0.0f, 0.0f});
    private FloatBuffer centerPosition = this.createFloatBuffer(new float[]{0.0f, 0.0f, -4.0f});
    private FloatBuffer centerVelocity = this.createFloatBuffer(new float[]{0.0f, 0.0f, 0.0f});
    private FloatBuffer rightPosition = this.createFloatBuffer(new float[]{2.0f, 0.0f, 0.0f});
    private FloatBuffer rightVelocity = this.createFloatBuffer(new float[]{0.0f, 0.0f, 0.0f});

    protected void execute(String[] args) {
        try {
            this.setup();
        }
        catch (Exception e) {
            System.out.println("Error setting up demonstration: ");
            e.printStackTrace();
            System.exit(-1);
        }
        this.run();
        this.shutdown();
    }

    private void setup() throws Exception {
        LWJGLUtil.log("Setting up window");
        int centerX = (Display.getDisplayMode().getWidth() - 640) / 2;
        int centerY = (Display.getDisplayMode().getHeight() - 480) / 2;
        this.setDisplayMode();
        Display.create();
        LWJGLUtil.log("Setting up OpenGL");
        GL11.glViewport(0, 0, 640, 480);
        GL11.glMatrixMode(5889);
        GL11.glLoadIdentity();
        GLU.gluPerspective(50.0f, 1.3333334f, 0.0f, 50.0f);
        GL11.glMatrixMode(5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef(0.0f, 0.0f, -6.6f);
        GL11.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        this.glut = new GLUT();
        Display.setVSyncEnabled(true);
        LWJGLUtil.log("Setting up OpenAL");
        AL10.alListener(4100, this.listenerPosition);
        AL10.alListener(4102, this.listenerVelocity);
        AL10.alListener(4111, this.listenerOrientation);
        LWJGLUtil.log("Creating buffers");
        AL10.alGenBuffers(this.soundBuffers);
        this.soundBuffers.rewind();
        AL10.alGenSources(this.soundSources);
        this.soundSources.rewind();
        LWJGLUtil.log("Loading soundfiles...");
        LWJGLUtil.log("Loading left.wav");
        WaveData left = WaveData.create("left.wav");
        AL10.alBufferData(this.soundBuffers.get(0), left.format, left.data, left.samplerate);
        AL10.alSourcef(this.soundSources.get(0), 4099, 1.0f);
        AL10.alSourcef(this.soundSources.get(0), 4106, 1.0f);
        AL10.alSource(this.soundSources.get(0), 4100, this.leftPosition);
        AL10.alSource(this.soundSources.get(0), 4102, this.leftVelocity);
        AL10.alSourcei(this.soundSources.get(0), 4105, this.soundBuffers.get(0));
        AL10.alSourcei(this.soundSources.get(0), 4103, 1);
        LWJGLUtil.log("Loading center.wav");
        WaveData center = WaveData.create("center.wav");
        AL10.alBufferData(this.soundBuffers.get(1), center.format, center.data, center.samplerate);
        AL10.alSourcef(this.soundSources.get(1), 4099, 1.0f);
        AL10.alSourcef(this.soundSources.get(1), 4106, 1.0f);
        AL10.alSource(this.soundSources.get(1), 4100, this.centerPosition);
        AL10.alSource(this.soundSources.get(1), 4102, this.centerVelocity);
        AL10.alSourcei(this.soundSources.get(1), 4105, this.soundBuffers.get(1));
        AL10.alSourcei(this.soundSources.get(1), 4103, 1);
        LWJGLUtil.log("Loading right.wav");
        WaveData right = WaveData.create("right.wav");
        AL10.alBufferData(this.soundBuffers.get(2), right.format, right.data, right.samplerate);
        AL10.alSourcef(this.soundSources.get(2), 4099, 1.0f);
        AL10.alSourcef(this.soundSources.get(2), 4106, 1.0f);
        AL10.alSource(this.soundSources.get(2), 4100, this.rightPosition);
        AL10.alSource(this.soundSources.get(2), 4102, this.rightVelocity);
        AL10.alSourcei(this.soundSources.get(2), 4105, this.soundBuffers.get(2));
        AL10.alSourcei(this.soundSources.get(2), 4103, 1);
        LWJGLUtil.log("Soundfiles loaded successfully");
        Mouse.setGrabbed(true);
    }

    private void run() {
        boolean firstRun = true;
        System.out.println("Press 1/4 (left), 2/5 (center) or 3/6 (right) to toggle sound");
        System.out.println("Press LEFT/RIGHT to move along x axis");
        System.out.println("Press SHIFT and either UP/DOWN to move along y axis");
        System.out.println("Press UP/DOWN to move along z axis");
        System.out.println("Move along the x and y axis with the mouse");
        System.out.println("Press LEFT or RIGHT mouse button to move along z axis");
        System.out.println("Press ESC to exit demo");
        LWJGLUtil.log("Listener position: " + this.listenerPosition.get(0) + ", " + this.listenerPosition.get(1) + ", " + this.listenerPosition.get(2));
        LWJGLUtil.log("Left position: " + this.leftPosition.get(0) + ", " + this.leftPosition.get(1) + ", " + this.leftPosition.get(2));
        LWJGLUtil.log("Center position: " + this.centerPosition.get(0) + ", " + this.centerPosition.get(1) + ", " + this.centerPosition.get(2));
        LWJGLUtil.log("Right position: " + this.rightPosition.get(0) + ", " + this.rightPosition.get(1) + ", " + this.rightPosition.get(2));
        while (!this.finished) {
            this.handleInput();
            Display.update();
            if (Display.isVisible()) {
                this.render();
            } else {
                this.pause(100L);
            }
            this.paused(!Display.isVisible() && !Display.isActive());
            if (!firstRun || this.pauseMode) continue;
            firstRun = false;
            this.startSounds();
        }
    }

    private void startSounds() {
        AL10.alSourcePlay(this.soundSources.get(0));
        this.pause(300L);
        AL10.alSourcePlay(this.soundSources.get(1));
        this.pause(500L);
        AL10.alSourcePlay(this.soundSources.get(2));
    }

    private void paused(boolean paused) {
        if (paused && !this.pauseMode) {
            this.pauseMode = true;
            AL10.alSourcePause(this.soundSources);
            System.out.println("pauseMode = true");
        } else if (!paused && this.pauseMode) {
            this.pauseMode = false;
            this.startSounds();
            System.out.println("pauseMode = false");
        }
    }

    private void handleInput() {
        boolean shift;
        boolean bl = this.finished = Display.isCloseRequested() || Keyboard.isKeyDown(1);
        if (this.finished) {
            return;
        }
        boolean bl2 = shift = Keyboard.isKeyDown(42) || Keyboard.isKeyDown(54);
        if (Keyboard.isKeyDown(2)) {
            AL10.alSourcePlay(this.soundSources.get(0));
            LWJGLUtil.log("Playing left.wav");
        }
        if (Keyboard.isKeyDown(3)) {
            AL10.alSourcePlay(this.soundSources.get(1));
            LWJGLUtil.log("Playing center.wav");
        }
        if (Keyboard.isKeyDown(4)) {
            AL10.alSourcePlay(this.soundSources.get(2));
            LWJGLUtil.log("Playing right.wav");
        }
        if (Keyboard.isKeyDown(5)) {
            AL10.alSourceStop(this.soundSources.get(0));
            LWJGLUtil.log("Stopped left.wav");
        }
        if (Keyboard.isKeyDown(6)) {
            AL10.alSourceStop(this.soundSources.get(1));
            LWJGLUtil.log("Stopped center.wav");
        }
        if (Keyboard.isKeyDown(7)) {
            AL10.alSourceStop(this.soundSources.get(2));
            LWJGLUtil.log("Stopped right.wav");
        }
        if (Keyboard.isKeyDown(203)) {
            this.listenerPosition.put(0, this.listenerPosition.get(0) - 0.1f);
            AL10.alListener(4100, this.listenerPosition);
        }
        if (Keyboard.isKeyDown(205)) {
            this.listenerPosition.put(0, this.listenerPosition.get(0) + 0.1f);
            AL10.alListener(4100, this.listenerPosition);
        }
        if (Keyboard.isKeyDown(200)) {
            if (shift) {
                this.listenerPosition.put(1, this.listenerPosition.get(1) + 0.1f);
            } else {
                this.listenerPosition.put(2, this.listenerPosition.get(2) - 0.1f);
            }
            AL10.alListener(4100, this.listenerPosition);
        }
        if (Keyboard.isKeyDown(208)) {
            if (shift) {
                this.listenerPosition.put(1, this.listenerPosition.get(1) - 0.1f);
            } else {
                this.listenerPosition.put(2, this.listenerPosition.get(2) + 0.1f);
            }
            AL10.alListener(4100, this.listenerPosition);
        }
        this.listenerPosition.put(0, this.listenerPosition.get(0) + 0.01f * (float)Mouse.getDX());
        this.listenerPosition.put(1, this.listenerPosition.get(1) + 0.01f * (float)Mouse.getDY());
        if (Mouse.isButtonDown(0)) {
            this.listenerPosition.put(2, this.listenerPosition.get(2) - 0.1f);
        }
        if (Mouse.isButtonDown(1)) {
            this.listenerPosition.put(2, this.listenerPosition.get(2) + 0.1f);
        }
        AL10.alListener(4100, this.listenerPosition);
        while (Mouse.next()) {
        }
    }

    private void render() {
        GL11.glClear(16640);
        GL11.glPushMatrix();
        GL11.glRotatef(20.0f, 1.0f, 1.0f, 0.0f);
        GL11.glPushMatrix();
        GL11.glTranslatef(this.leftPosition.get(0), this.leftPosition.get(1), this.leftPosition.get(2));
        GL11.glColor3f(1.0f, 0.0f, 0.0f);
        this.glut.glutWireCube(0.5f);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef(this.centerPosition.get(0), this.centerPosition.get(1), this.centerPosition.get(2));
        GL11.glColor3f(0.0f, 0.0f, 1.0f);
        this.glut.glutWireCube(0.5f);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef(this.rightPosition.get(0), this.rightPosition.get(1), this.rightPosition.get(2));
        GL11.glColor3f(0.0f, 1.0f, 0.0f);
        this.glut.glutWireCube(0.5f);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef(this.listenerPosition.get(0), this.listenerPosition.get(1), this.listenerPosition.get(2));
        GL11.glColor3f(1.0f, 1.0f, 1.0f);
        this.glut.glutSolidCube(0.5f);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    private void shutdown() {
        LWJGLUtil.log("Shutting down OpenAL");
        AL10.alSourceStop(this.soundSources);
        AL10.alDeleteSources(this.soundSources);
        AL10.alDeleteBuffers(this.soundBuffers);
        AL.destroy();
        LWJGLUtil.log("Shutting down Window");
        Display.destroy();
    }

    public static void main(String[] args) {
        PositionTest positionTest = new PositionTest();
        positionTest.execute(args);
        System.exit(0);
    }

    class GLUT {
        float[][] n = new float[][]{{-1.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {1.0f, 0.0f, 0.0f}, {0.0f, -1.0f, 0.0f}, {0.0f, 0.0f, 1.0f}, {0.0f, 0.0f, -1.0f}};
        int[][] faces = new int[][]{{0, 1, 2, 3}, {3, 2, 6, 7}, {7, 6, 5, 4}, {4, 5, 1, 0}, {5, 6, 2, 1}, {7, 4, 0, 3}};
        float[][] v = new float[8][3];

        GLUT() {
        }

        public void glutWireCube(float size) {
            this.drawBox(size, 2);
        }

        public void glutSolidCube(float size) {
            this.drawBox(size, 7);
        }

        private void drawBox(float size, int type) {
            float f = -size / 2.0f;
            this.v[3][0] = f;
            this.v[2][0] = f;
            this.v[1][0] = f;
            this.v[0][0] = f;
            float f2 = size / 2.0f;
            this.v[7][0] = f2;
            this.v[6][0] = f2;
            this.v[5][0] = f2;
            this.v[4][0] = f2;
            float f3 = -size / 2.0f;
            this.v[5][1] = f3;
            this.v[4][1] = f3;
            this.v[1][1] = f3;
            this.v[0][1] = f3;
            float f4 = size / 2.0f;
            this.v[7][1] = f4;
            this.v[6][1] = f4;
            this.v[3][1] = f4;
            this.v[2][1] = f4;
            float f5 = -size / 2.0f;
            this.v[7][2] = f5;
            this.v[4][2] = f5;
            this.v[3][2] = f5;
            this.v[0][2] = f5;
            float f6 = size / 2.0f;
            this.v[6][2] = f6;
            this.v[5][2] = f6;
            this.v[2][2] = f6;
            this.v[1][2] = f6;
            for (int i = 5; i >= 0; --i) {
                GL11.glBegin(type);
                GL11.glNormal3f(this.n[i][0], this.n[i][1], this.n[i][2]);
                GL11.glVertex3f(this.v[this.faces[i][0]][0], this.v[this.faces[i][0]][1], this.v[this.faces[i][0]][2]);
                GL11.glVertex3f(this.v[this.faces[i][1]][0], this.v[this.faces[i][1]][1], this.v[this.faces[i][1]][2]);
                GL11.glVertex3f(this.v[this.faces[i][2]][0], this.v[this.faces[i][2]][1], this.v[this.faces[i][2]][2]);
                GL11.glVertex3f(this.v[this.faces[i][3]][0], this.v[this.faces[i][3]][1], this.v[this.faces[i][3]][2]);
                GL11.glEnd();
            }
        }
    }
}

