/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.examples.spaceinvaders;

import org.lwjgl.opengl.GL11;

public class Texture {
    private int target;
    private int textureID;
    private int height;
    private int width;
    private int texWidth;
    private int texHeight;
    private float widthRatio;
    private float heightRatio;

    public Texture(int target, int textureID) {
        this.target = target;
        this.textureID = textureID;
    }

    public void bind() {
        GL11.glBindTexture(this.target, this.textureID);
    }

    public void setHeight(int height) {
        this.height = height;
        this.setHeight();
    }

    public void setWidth(int width) {
        this.width = width;
        this.setWidth();
    }

    public int getImageHeight() {
        return this.height;
    }

    public int getImageWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.heightRatio;
    }

    public float getWidth() {
        return this.widthRatio;
    }

    public void setTextureHeight(int texHeight) {
        this.texHeight = texHeight;
        this.setHeight();
    }

    public void setTextureWidth(int texWidth) {
        this.texWidth = texWidth;
        this.setWidth();
    }

    private void setHeight() {
        if (this.texHeight != 0) {
            this.heightRatio = (float)this.height / (float)this.texHeight;
        }
    }

    private void setWidth() {
        if (this.texWidth != 0) {
            this.widthRatio = (float)this.width / (float)this.texWidth;
        }
    }
}

