/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.PixelFormat;
import org.lwjgl.util.glu.GLU;

public class Render {
    private String title = "";
    private Camera camera;
    private int width;
    private int height;
    private boolean fullscreen;
    private OJ2D oj2d = new OJ2D();

    public Render(String title, Camera camera, int width, int height, boolean fullScreen) {
        this.title = title;
        this.camera = camera;
        this.fullscreen = fullScreen;
        this.width = width;
        this.height = height;
    }

    public void beginRender() {
        GL11.glClear(16640);
        this.goPerspective();
        this.oj2d.beginRender();
        this.setCamera(this.camera.pos, this.camera.rot);
    }

    public void endRender() {
        this.goOrtho();
        this.oj2d.render();
        this.goPerspective();
        Display.update();
        Display.sync(60);
    }

    public ByteBuffer loadIcon(String filename, int width, int height) throws IOException {
        BufferedImage image = ImageIO.read(new File(filename));
        byte[] imageBytes = new byte[width * height * 4];
        int i = 0;
        while (i < height) {
            int j = 0;
            while (j < width) {
                int pixel = image.getRGB(j, i);
                int k = 0;
                while (k < 3) {
                    imageBytes[(i * 16 + j) * 4 + k] = (byte)(pixel >> (2 - k) * 8 & 0xFF);
                    ++k;
                }
                imageBytes[(i * 16 + j) * 4 + 3] = (byte)(pixel >> 24 & 0xFF);
                ++j;
            }
            ++i;
        }
        return ByteBuffer.wrap(imageBytes);
    }

    private void setDisplayMode(int width, int height, boolean fullscreen) {
        if (Display.getDisplayMode().getWidth() == width && Display.getDisplayMode().getHeight() == height && Display.isFullscreen() == fullscreen) {
            return;
        }
        try {
            DisplayMode targetDisplayMode = null;
            if (fullscreen) {
                DisplayMode[] modes = Display.getAvailableDisplayModes();
                int freq = 0;
                int i = 0;
                while (i < modes.length) {
                    DisplayMode current = modes[i];
                    if (current.getWidth() == width && current.getHeight() == height) {
                        if (!(targetDisplayMode != null && current.getFrequency() < freq || targetDisplayMode != null && current.getBitsPerPixel() <= targetDisplayMode.getBitsPerPixel())) {
                            targetDisplayMode = current;
                            freq = targetDisplayMode.getFrequency();
                        }
                        if (current.getBitsPerPixel() == Display.getDesktopDisplayMode().getBitsPerPixel() && current.getFrequency() == Display.getDesktopDisplayMode().getFrequency()) {
                            targetDisplayMode = current;
                            break;
                        }
                    }
                    ++i;
                }
            } else {
                targetDisplayMode = new DisplayMode(width, height);
            }
            if (targetDisplayMode == null) {
                System.out.println("Failed to find value mode: " + width + "x" + height + " fs=" + fullscreen);
                return;
            }
            Display.setDisplayMode(targetDisplayMode);
            Display.setFullscreen(fullscreen);
        }
        catch (LWJGLException e) {
            System.out.println("Unable to setup mode " + width + "x" + height + " fullscreen=" + fullscreen + e);
        }
    }

    public void init() {
        try {
            this.setDisplayMode(this.width, this.height, this.fullscreen);
            Display.setTitle(this.title);
            Display.create(new PixelFormat(8, 8, 0, 8));
            if (this.fullscreen) {
                Display.setVSyncEnabled(true);
            }
            GL11.glEnable(3553);
            GL11.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            GL11.glEnable(3042);
            GL11.glBlendFunc(770, 771);
            GL11.glViewport(0, 0, this.width, this.height);
            GL11.glEnable(3553);
        }
        catch (LWJGLException e) {
            e.printStackTrace();
        }
        this.oj2d.init();
        this.goPerspective();
    }

    public void goPerspective() {
        GL11.glEnable(2929);
        GL11.glMatrixMode(5889);
        GL11.glLoadIdentity();
        GLU.gluPerspective(45.0f, (float)this.width / (float)this.height, 1.0f, 10000.0f);
        GL11.glMatrixMode(5888);
        GL11.glLoadIdentity();
    }

    public void goOrtho() {
        GL11.glDisable(2929);
        GL11.glMatrixMode(5889);
        GL11.glLoadIdentity();
        GL11.glOrtho(0.0, this.width, this.height, 0.0, -1.0, 1.0);
        GL11.glMatrixMode(5888);
        GL11.glLoadIdentity();
    }

    public void setCamera(Vec3 pos, Vec3 rot) {
        GL11.glRotatef(-rot.x, 1.0f, 0.0f, 0.0f);
        GL11.glRotatef(-rot.y, 0.0f, 1.0f, 0.0f);
        GL11.glRotatef(-rot.z, 0.0f, 0.0f, 1.0f);
        GL11.glTranslatef(-pos.x, -pos.y, -pos.z);
    }

    public void addFont(String name, Font f) {
        this.oj2d.addFont(name, f);
    }

    public void drawString(int x, int y, String s, Vec3 color, String font) {
        this.oj2d.drawString(x, y, s, font, color);
    }

    public void drawString(int x, int y, String s, Vec3 colorFront, Vec3 colorBack, String font) {
        this.oj2d.drawString(x + 3, y + 3, s, font, colorBack);
        this.oj2d.drawString(x, y, s, font, colorFront);
    }

    public void fillRect(int x, int y, int w, int h, Vec3 color) {
        this.oj2d.fillRect(x, y, w, h, color);
    }

    public void drawRect(int x, int y, int w, int h, Vec3 color) {
        this.oj2d.drawRect(x, y, w, h, color);
    }

    public void drawLine(int x1, int y1, int x2, int y2, Vec3 color) {
        this.oj2d.drawLine(x1, y1, x2, y2, color);
    }

    public void drawImage(int x, int y, int w, int h, int ID) {
        this.oj2d.drawImage(x, y, w, h, ID);
    }
}

