/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;

public class Main {
    private Camera camera = new Camera();
    public static final int width = 1280;
    public static final int height = 720;
    private boolean fullscreen = true;
    private static int LOCAL_SLEEP_TIME = 16;
    private Render render = new Render("DEMO", this.camera, 1280, 720, this.fullscreen);
    private Input input = new Input();
    public static final Sound SOUND = new Sound(1.0, 1.0);
    private State state = State.STARTING;
    private int tick = 0;
    private static OBJExtractor.OBJ head;
    private static OBJExtractor.OBJ nose;
    private Vec3 orange = new Vec3(241.0f, 142.0f, 66.0f).multiply(0.003921569f);
    private Vec3 bodycol = new Vec3(0.7f);
    ArrayList<Cube> cubes = new ArrayList();
    double a = 0.0;
    double da = 0.0075;
    double r = 5.0;
    int s = 30;
    float[][] h = new float[this.s][this.s];
    boolean[][] gol = new boolean[this.s][this.s];

    static {
        OBJExtractor obje = new OBJExtractor();
        head = obje.loadModel("birdie_head.obj");
        nose = obje.loadModel("birdie_nose.obj");
    }

    public static void main(String[] args) {
        new Main();
    }

    public Main() {
        this.render.init();
        Fonts.initFonts(this.render);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        SOUND.setMusic(Sound.MUSIC);
        while (!Display.isCloseRequested()) {
            this.input.poll();
            this.update();
            ++this.tick;
            this.render.beginRender();
            try {
                this.render();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.render.endRender();
            if (this.input.isKeyDown(1) || 76000 < Main.TICKS_TO_MILLIS(this.tick)) break;
        }
        System.exit(0);
    }

    public Camera getCamera() {
        return this.camera;
    }

    private void render() {
        int x = 200;
        int y = 200;
        switch (this.state) {
            case STARTING: {
                this.render.drawString(50, 50, "V\u00e4lkommen till Birdie 2024", Vec3.CYAN, "MENU_FONT");
                break;
            }
            case INTRO: {
                Vec3 siz = new Vec3(1.0f - (float)this.tick * 0.002f);
                Box.renderBox(new Vec3(0.0f, 0.0f, 0.0f), siz, Vec3.RED);
                Box.renderBox(new Vec3(2.0f, 0.0f, 0.0f), siz, Vec3.RED);
                Box.renderBox(new Vec3(-2.0f, 0.0f, 0.0f), siz, Vec3.RED);
                Box.renderBox(new Vec3(0.0f, 2.0f, 0.0f), siz, Vec3.RED);
                Box.renderBox(new Vec3(0.0f, -2.0f, 0.0f), siz, Vec3.RED);
                Box.renderBox(new Vec3(0.0f, 0.0f, 2.0f), siz, Vec3.RED);
                Box.renderBox(new Vec3(0.0f, 0.0f, -2.0f), siz, Vec3.RED);
                GL11.glPushMatrix();
                int tex = Box.demoSky;
                Box.renderBox(new Vec3(), new Vec3(100.0f), Vec3.RED, new int[]{tex, tex, tex, tex, tex, tex});
                int i = 0;
                while (i < this.cubes.size()) {
                    this.cubes.get(i).render();
                    ++i;
                }
                GL11.glPopMatrix();
                break;
            }
            case CHAOS: {
                this.render.drawString((int)(Math.random() * 1280.0), (int)(Math.random() * 720.0), "BIRDIE", Vec3.WHITE, Vec3.BLACK, "MENU_FONT");
            }
            case INTER1: {
                Vec3 botRight;
                Vec3 topRight;
                Vec3 topLeft;
                this.camera.pos = new Vec3(0.0f, 1.0f, 5.0f);
                this.camera.rot = new Vec3(0.0f, 0.0f, this.tick);
                GL11.glPushMatrix();
                GL11.glRotatef(-90.0f, 0.0f, 1.0f, 0.0f);
                float scale = (float)(30.0 + Math.sin((double)this.tick * 0.07) * 20.0);
                int i = 0;
                while (i < Main.head.faces.size()) {
                    topLeft = Main.head.vecs.get(Main.head.faces.get(i).get(0) - 1);
                    topRight = Main.head.vecs.get(Main.head.faces.get(i).get(1) - 1);
                    botRight = Main.head.vecs.get(Main.head.faces.get(i).get(2) - 1);
                    topLeft = topLeft.multiply(scale);
                    topRight = topRight.multiply(scale);
                    botRight = botRight.multiply(scale);
                    Quad.renderQuad(topLeft, topRight, botRight, botRight, this.bodycol);
                    ++i;
                }
                i = 0;
                while (i < Main.nose.faces.size()) {
                    topLeft = Main.nose.vecs.get(Main.nose.faces.get(i).get(0) - 1);
                    topRight = Main.nose.vecs.get(Main.nose.faces.get(i).get(1) - 1);
                    botRight = Main.nose.vecs.get(Main.nose.faces.get(i).get(2) - 1);
                    topLeft = topLeft.multiply(scale);
                    topRight = topRight.multiply(scale);
                    botRight = botRight.multiply(scale);
                    Quad.renderQuad(topLeft, topRight, botRight, botRight, this.orange);
                    ++i;
                }
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                GL11.glTranslatef(2.0f, 0.0f, 0.0f);
                GL11.glRotatef(0.0f, 0.0f, 1.0f, 0.0f);
                scale = (float)(30.0 + Math.sin((double)this.tick * 0.1) * 40.0);
                i = 0;
                while (i < Main.head.faces.size()) {
                    topLeft = Main.head.vecs.get(Main.head.faces.get(i).get(0) - 1);
                    topRight = Main.head.vecs.get(Main.head.faces.get(i).get(1) - 1);
                    botRight = Main.head.vecs.get(Main.head.faces.get(i).get(2) - 1);
                    topLeft = topLeft.multiply(scale);
                    topRight = topRight.multiply(scale);
                    botRight = botRight.multiply(scale);
                    Quad.renderQuad(topLeft, topRight, botRight, botRight, this.bodycol);
                    ++i;
                }
                i = 0;
                while (i < Main.nose.faces.size()) {
                    topLeft = Main.nose.vecs.get(Main.nose.faces.get(i).get(0) - 1);
                    topRight = Main.nose.vecs.get(Main.nose.faces.get(i).get(1) - 1);
                    botRight = Main.nose.vecs.get(Main.nose.faces.get(i).get(2) - 1);
                    topLeft = topLeft.multiply(scale);
                    topRight = topRight.multiply(scale);
                    botRight = botRight.multiply(scale);
                    Quad.renderQuad(topLeft, topRight, botRight, botRight, this.orange);
                    ++i;
                }
                GL11.glPopMatrix();
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                GL11.glTranslatef(-2.0f, 0.0f, 0.0f);
                GL11.glRotatef(180.0f, 0.0f, 1.0f, 0.0f);
                scale = (float)(30.0 + Math.cos((double)this.tick * 0.05) * 30.0);
                i = 0;
                while (i < Main.head.faces.size()) {
                    topLeft = Main.head.vecs.get(Main.head.faces.get(i).get(0) - 1);
                    topRight = Main.head.vecs.get(Main.head.faces.get(i).get(1) - 1);
                    botRight = Main.head.vecs.get(Main.head.faces.get(i).get(2) - 1);
                    topLeft = topLeft.multiply(scale);
                    topRight = topRight.multiply(scale);
                    botRight = botRight.multiply(scale);
                    Quad.renderQuad(topLeft, topRight, botRight, botRight, this.bodycol);
                    ++i;
                }
                i = 0;
                while (i < Main.nose.faces.size()) {
                    topLeft = Main.nose.vecs.get(Main.nose.faces.get(i).get(0) - 1);
                    topRight = Main.nose.vecs.get(Main.nose.faces.get(i).get(1) - 1);
                    botRight = Main.nose.vecs.get(Main.nose.faces.get(i).get(2) - 1);
                    topLeft = topLeft.multiply(scale);
                    topRight = topRight.multiply(scale);
                    botRight = botRight.multiply(scale);
                    Quad.renderQuad(topLeft, topRight, botRight, botRight, this.orange);
                    ++i;
                }
                GL11.glPopMatrix();
                int tex = Box.demoSky;
                Box.renderBox(new Vec3(), new Vec3(100.0f), Vec3.RED, new int[]{tex, tex, tex, tex, tex, tex});
                break;
            }
            case SEHN: {
                GL11.glPushMatrix();
                int tex = Box.demoSky;
                Box.renderBox(new Vec3(), new Vec3(100.0f), Vec3.RED, new int[]{tex, tex, tex, tex, tex, tex});
                int i = 0;
                while (i < this.cubes.size()) {
                    this.cubes.get(i).render();
                    ++i;
                }
                GL11.glPopMatrix();
                break;
            }
            case WAR: {
                GL11.glPushMatrix();
                int tex = Box.demoSky;
                Box.renderBox(new Vec3(), new Vec3(100.0f), Vec3.RED, new int[]{tex, tex, tex, tex, tex, tex});
                int i = 0;
                while (i < this.cubes.size()) {
                    this.cubes.get(i).render();
                    ++i;
                }
                GL11.glPopMatrix();
                break;
            }
            case WOLLT: {
                GL11.glPushMatrix();
                int tex2 = Box.demoSky;
                Box.renderBox(new Vec3(), new Vec3(100.0f), Vec3.RED, new int[]{tex2, tex2, tex2, tex2, tex2, tex2});
                GL11.glPushMatrix();
                GL11.glTranslatef(-this.s / 2, 0.0f, -this.s / 2);
                int xi = 0;
                while (xi < this.s - 1) {
                    int z = 0;
                    while (z < this.s - 1) {
                        Quad.renderQuad(new Vec3(xi, this.h[xi][z], z), new Vec3((float)xi + 0.9f, this.h[xi + 1][z], z), new Vec3((float)xi + 0.9f, this.h[xi + 1][z + 1], (float)z + 0.9f), new Vec3(xi, this.h[xi][z + 1], (float)z + 0.9f), this.gol[xi][z] ? Vec3.BLACK : Vec3.BLUE);
                        ++z;
                    }
                    ++xi;
                }
                GL11.glPopMatrix();
                GL11.glPopMatrix();
                break;
            }
        }
    }

    private void update() {
        boolean newstate = this.setState();
        switch (this.state) {
            case CHAOS: {
                break;
            }
            case INTER1: {
                break;
            }
            case INTRO: {
                this.camera.pos = new Vec3(0.0f, 0.0f, 0.0f);
                this.camera.rot = new Vec3(this.tick, this.tick, this.tick);
                int i = 0;
                while (i < 3) {
                    Vec3 pos = new Vec3((float)(Math.random() - 0.5) * 50.0f, (float)(Math.random() - 0.5) * 50.0f, (float)(Math.random() - 0.5) * 50.0f);
                    this.cubes.add(new Cube(pos));
                    ++i;
                }
                break;
            }
            case SEHN: {
                if (newstate) {
                    this.cubes = new ArrayList();
                    int i = 0;
                    while (i < 3000) {
                        Vec3 pos = new Vec3((float)(Math.random() - 0.5) * 50.0f, (float)(Math.random() - 0.5) * 50.0f, (float)(Math.random() - 0.5) * 50.0f);
                        this.cubes.add(new Cube(pos));
                        this.cubes.get((int)i).rot = new Vec3((float)(Math.random() * 360.0), (float)(Math.random() * 360.0), (float)(Math.random() * 360.0));
                        ++i;
                    }
                }
                this.camera.pos.x += 0.01f;
                this.camera.rot.x += 0.1f;
                for (Cube c : this.cubes) {
                    c.size = c.size.add(new Vec3((float)(Math.random() - 0.5) * 0.1f));
                }
                break;
            }
            case STARTING: {
                break;
            }
            case WAR: {
                int i;
                if (newstate) {
                    this.camera.pos = new Vec3();
                    this.camera.rot = new Vec3();
                    this.cubes = new ArrayList();
                    i = 0;
                    while (i < 300) {
                        Vec3 pos = new Vec3((float)i * 0.01f, 0.0f, (float)Math.random());
                        this.cubes.add(new Cube(pos));
                        ++i;
                    }
                }
                this.camera.rot.z += 2.0f;
                this.camera.pos.x = (float)(0.0 + Math.sin((double)this.tick * 0.005) * 4.0);
                this.camera.pos.y = (float)(0.0 + Math.sin((double)this.tick * 0.0025) * 2.0);
                this.camera.pos.z = (float)(12.0 + Math.sin((double)this.tick * 0.01) * 5.0);
                this.a += (double)0.03f;
                i = 0;
                while (i < this.cubes.size()) {
                    this.cubes.get((int)i).pos.x = (float)(Math.sin(this.a + this.da * (double)i) * this.r);
                    this.cubes.get((int)i).pos.z = (float)(Math.cos(this.a + this.da * (double)i) * this.r);
                    this.cubes.get((int)i).pos.y = (float)Math.sin(this.cubes.get((int)i).pos.x);
                    ++i;
                }
                break;
            }
            case WOLLT: {
                if (newstate) {
                    this.camera.pos = new Vec3();
                    this.camera.rot = new Vec3();
                    int x = 0;
                    while (x < this.gol.length) {
                        int z = 0;
                        while (z < this.gol[x].length) {
                            this.gol[x][z] = Math.random() > 0.7;
                            ++z;
                        }
                        ++x;
                    }
                }
                this.camera.rot.x = -40.0f;
                this.camera.pos.y = 15.0f;
                double a = (float)this.tick * 0.01f;
                this.camera.rot.y = (float)Math.toDegrees(a);
                this.camera.pos.x = (float)(Math.sin(a) * 30.0);
                this.camera.pos.z = (float)(Math.cos(a) * 30.0);
                int x = 0;
                while (x < this.h.length) {
                    int z = 0;
                    while (z < this.h[x].length) {
                        this.h[x][z] = (float)(Math.sin((double)((x + z) * 3 + this.tick) * 0.1) * 0.5);
                        ++z;
                    }
                    ++x;
                }
                if (this.tick % 10 != 0) break;
                boolean[][] ngol = new boolean[this.s][this.s];
                int x2 = 0;
                while (x2 < this.gol.length) {
                    int z = 0;
                    while (z < this.gol[x2].length) {
                        int n = 0;
                        n += this.isOn(x2 - 1, z - 1);
                        n += this.isOn(x2, z - 1);
                        n += this.isOn(x2 + 1, z - 1);
                        n += this.isOn(x2 - 1, z);
                        n += this.isOn(x2 + 1, z);
                        n += this.isOn(x2 - 1, z + 1);
                        n += this.isOn(x2, z + 1);
                        if ((n += this.isOn(x2 + 1, z + 1)) < 2) {
                            ngol[x2][z] = false;
                        }
                        if (n == 3) {
                            ngol[x2][z] = true;
                        }
                        if (n == 2 && this.gol[x2][z]) {
                            ngol[x2][z] = true;
                        }
                        ++z;
                    }
                    ++x2;
                }
                this.gol = ngol;
                break;
            }
        }
    }

    private int isOn(int x, int z) {
        if (x < 0 || z < 0 || x >= this.s || z >= this.s) {
            return 0;
        }
        return this.gol[x][z] ? 1 : 0;
    }

    private boolean setState() {
        State s = this.state;
        int millis = Main.TICKS_TO_MILLIS(this.tick);
        if (millis < 8500) {
            this.state = State.INTRO;
        } else if (millis > 8500 && millis < 17500 || millis > 40500 && millis < 49000 || millis > 61500 && millis < 68000) {
            this.state = State.WOLLT;
        } else if (millis > 17500 && millis < 24500 || millis > 68000) {
            this.state = State.WAR;
        } else if (millis > 24500 && millis < 33500 || millis > 52000 && millis < 61500) {
            this.state = State.SEHN;
        } else if (millis > 33500 && millis < 40500) {
            this.state = State.INTER1;
        } else if (millis > 49000 && millis < 52000) {
            this.state = State.CHAOS;
        }
        return s != this.state;
    }

    public static int MILLIS_TO_TICKS(int millis) {
        return millis / LOCAL_SLEEP_TIME;
    }

    public static int TICKS_TO_MILLIS(int ticks) {
        return ticks * LOCAL_SLEEP_TIME;
    }

    private static enum State {
        STARTING,
        INTRO,
        WOLLT,
        WAR,
        SEHN,
        INTER1,
        CHAOS;

    }
}

