function(check_c_flag flag var)
  include(CheckCCompilerFlag)
  set(output_message "-- C compiler flag ${flag} - ")
  check_c_compiler_flag("${flag}" ${var})
  if(${var})
    if(ARGV2)
      if("DEBUG" STREQUAL "${ARGV2}")
        string(REGEX REPLACE "^ +" "" CMAKE_C_FLAGS_DEBUG_NEW "${CMAKE_C_FLAGS_DEBUG} ${flag}")
        set(CMAKE_C_FLAGS_DEBUG "${CMAKE_C_FLAGS_DEBUG_NEW}")
        set(CMAKE_C_FLAGS_DEBUG "${CMAKE_C_FLAGS_DEBUG_NEW}" PARENT_SCOPE)
      elseif("RELEASE" STREQUAL "${ARGV2}")
        string(REGEX REPLACE "^ +" "" CMAKE_C_FLAGS_RELEASE_NEW "${CMAKE_C_FLAGS_RELEASE} ${flag}")
        set(CMAKE_C_FLAGS_RELEASE "${CMAKE_C_FLAGS_RELEASE_NEW}")
        set(CMAKE_C_FLAGS_RELEASE "${CMAKE_C_FLAGS_RELEASE_NEW}" PARENT_SCOPE)
      else()
        message(SEND_ERROR "unknown build type ${ARGV1}")
      endif()
    else()
      string(REGEX REPLACE "^ +" "" CMAKE_C_FLAGS_NEW "${CMAKE_C_FLAGS} ${flag}")
      set(CMAKE_C_FLAGS "${CMAKE_C_FLAGS_NEW}")
      set(CMAKE_C_FLAGS "${CMAKE_C_FLAGS_NEW}" PARENT_SCOPE)
    endif()
    message("${output_message}accepted")
  else()
    message("${output_message}not accepted")
  endif()
endfunction()

function(check_cxx_flag flag var)
  include(CheckCXXCompilerFlag)
  set(output_message "-- C++ compiler flag ${flag} - ")
  CHECK_CXX_COMPILER_FLAG("${flag}" ${var})
  if(${var})
    if(ARGV2)
      if("DEBUG" STREQUAL "${ARGV2}")
        string(REGEX REPLACE "^ +" "" CMAKE_CXX_FLAGS_DEBUG_NEW "${CMAKE_CXX_FLAGS_DEBUG} ${flag}")
        set(CMAKE_CXX_FLAGS_DEBUG "${CMAKE_CXX_FLAGS_DEBUG_NEW}")
        set(CMAKE_CXX_FLAGS_DEBUG "${CMAKE_CXX_FLAGS_DEBUG_NEW}" PARENT_SCOPE)
      elseif("RELEASE" STREQUAL "${ARGV2}")
        string(REGEX REPLACE "^ +" "" CMAKE_CXX_FLAGS_RELEASE_NEW "${CMAKE_CXX_FLAGS_RELEASE} ${flag}")
        set(CMAKE_CXX_FLAGS_RELEASE "${CMAKE_CXX_FLAGS_RELEASE_NEW}")
        set(CMAKE_CXX_FLAGS_RELEASE "${CMAKE_CXX_FLAGS_RELEASE_NEW}" PARENT_SCOPE)
      else()
        message(SEND_ERROR "unknown build type ${ARGV1}")
      endif()
    else()
      string(REGEX REPLACE "^ +" "" CMAKE_CXX_FLAGS_NEW "${CMAKE_CXX_FLAGS} ${flag}")
      set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS_NEW}")
      set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS_NEW}" PARENT_SCOPE)
    endif()
    message("${output_message}accepted")
  else()
    message("${output_message}not accepted")
  endif()
endfunction()

function(check_include_directory dir)
  set(dir_mode "")
  if(ARGV1)
    string(TOLOWER "${ARGV1} " dir_mode)
  endif()
  set(output_message "-- Looking for ${dir_mode}include directory '${dir}' - ")
  if(EXISTS "${dir}/")
    message("${output_message}found")
    if(ARGV1)
      include_directories("${ARGV1}" "${dir}")
    else()
      include_directories("${dir}")
    endif()
  else()
    message("${output_message}not found")
  endif()
endfunction()

macro(find_pkgconfig package)
  include(FindPkgConfig)
  set(lib_mode SHARED)
  if(ARGV2)
    set(lib_mode "${ARGV2}")
  endif()
  pkg_search_module(PKG_CONFIG_TEMP "${package}")
  if(PKG_CONFIG_TEMP_FOUND)
    #message("include dirs: ${PKG_CONFIG_TEMP_INCLUDE_DIRS}")
    #message("library dirs: ${PKG_CONFIG_TEMP_LIBRARY_DIRS}")
    #message("ldflags: ${PKG_CONFIG_TEMP_LDFLAGS}")
    #message("ldflags other: ${PKG_CONFIG_TEMP_LDFLAGS_OTHER}")
    #message("cflags: ${PKG_CONFIG_TEMP_CFLAGS}")
    #message("cflags other: ${PKG_CONFIG_TEMP_CFLAGS_OTHER}")
    if(PKG_CONFIG_TEMP_INCLUDE_DIRS)
      include_directories("${PKG_CONFIG_TEMP_INCLUDE_DIRS}")
    endif()
    if(PKG_CONFIG_TEMP_LIBRARY_DIRS)
      link_directories("${PKG_CONFIG_TEMP_LIBRARY_DIRS}")
    endif()
    if(PKG_CONFIG_TEMP_CFLAGS)
      add_definitions(${PKG_CONFIG_TEMP_CFLAGS})
    endif()
    if(PKG_CONFIG_TEMP_CFLAGS_OTHER)
      add_definitions(${PKG_CONFIG_TEMP_CFLAGS_OTHER})
    endif()
    message("-- Found ${package}: ${PKG_CONFIG_TEMP_VERSION}")
  elseif(ARGV1)
    message(SEND_ERROR "${package} required but not found")
  endif()
  unset(PKG_CONFIG_TEMP)
  unset(PKG_CONFIG_TEMP_INCLUDE_DIRS)
  unset(PKG_CONFIG_TEMP_LIBRARY_DIRS)
  unset(PKG_CONFIG_TEMP_CFLAGS)
  unset(PKG_CONFIG_TEMP_CFLAGS_OTHER)
  unset(PKG_CONFIG_TEMP_LDFLAGS)
  unset(PKG_CONFIG_TEMP_LDFLAGS_OTHER)
  unset(PKG_CONFIG_TEMP_LIBRARIES_DIRS)
  unset(PKG_CONFIG_TEMP_VERSION)
endmacro()

function(find_boost)
  set(Boost_USE_STATIC_LIBS on)
  if(ARGV1)
    find_package(Boost 1.42.0 REQUIRED "${ARGV1}")
  else()
    find_package(Boost 1.42.0 REQUIRED)
  endif()
  if(Boost_FOUND)
    include_directories(${Boost_INCLUDE_DIRS})
  elseif(ARGV0)
    message(SEND_ERROR "Boost required but not found")
  endif()
  set(BOOST_LIBRARY "${Boost_LIBRARIES}")
  set(BOOST_LIBRARY "${Boost_LIBRARIES}" PARENT_SCOPE)
endfunction()

function(find_gl)
  include(FindOpenGL)
  if(OPENGL_FOUND)
    message("-- Found GL: ${OPENGL_gl_LIBRARY}")
  elseif(ARGV0)
    message(SEND_ERROR "GL required but not found")
  endif()
endfunction()

function(find_glew)
  if(ARGV1)
    find_pkgconfig(glew "${ARGV0}" "${ARGV1}")
  elseif(ARGV0)
    find_pkgconfig(glew "${ARGV0}")
  else()
    find_pkgconfig(glew)
  endif()
  set(GLEW_LIBRARY "${PKG_CONFIG_TEMP_LIBRARIES}")
  set(GLEW_LIBRARY "${PKG_CONFIG_TEMP_LIBRARIES}" PARENT_SCOPE)
  unset(PKG_CONFIG_TEMP_LIBRARIES)
endfunction()

function(find_glu)
  include(FindOpenGL)
  if(OPENGL_GLU_FOUND)
    message("-- Found GLU: ${OPENGL_glu_LIBRARY}")
  elseif(ARGV0)
    message(SEND_ERROR "GLU required but not found")
  endif()
endfunction()

function(find_png)
  include(FindPNG)
  if(PNG_FOUND)
    include_directories("${PNG_INCLUDE_DIRS}")
    add_definitions(${PNG_DEFINITIONS})
    set(PNG_LIBRARY "${PNG_LIBRARIES}")
    set(PNG_LIBRARY "${PNG_LIBRARIES}" PARENT_SCOPE)
  elseif(ARGV0)
    message(SEND_ERROR "libpng required but not found")
  endif()
endfunction()

function(find_sdl)
  include(FindSDL)
  set(lib_mode SHARED)
  if(ARGV1)
    set(lib_mode ARGV1)
  endif()
  if(SDL_FOUND)
    include_directories(${SDL_INCLUDE_DIR})
  elseif(ARGV0)
    message(SEND_ERROR "SDL required but not found")
  endif()
endfunction()

function(output_flags)
  if(ARGV0)
    if(${MSVC})
      string(REGEX REPLACE "^ +" "" CMAKE_C_FLAGS_DEBUG_NEW "${CMAKE_C_FLAGS_DEBUG} /D${ARGV0}")
      string(REGEX REPLACE "^ +" "" CMAKE_CXX_FLAGS_DEBUG_NEW "${CMAKE_CXX_FLAGS_DEBUG} /D${ARGV0}")
    else()
      string(REGEX REPLACE "^ +" "" CMAKE_C_FLAGS_DEBUG_NEW "${CMAKE_C_FLAGS_DEBUG} -D${ARGV0}")
      string(REGEX REPLACE "^ +" "" CMAKE_CXX_FLAGS_DEBUG_NEW "${CMAKE_C_FLAGS_DEBUG} -D${ARGV0}")
    endif()
    set(CMAKE_C_FLAGS_DEBUG "${CMAKE_C_FLAGS_DEBUG_NEW}")
    set(CMAKE_C_FLAGS_DEBUG "${CMAKE_C_FLAGS_DEBUG_NEW}" PARENT_SCOPE)
    set(CMAKE_CXX_FLAGS_DEBUG "${CMAKE_CXX_FLAGS_DEBUG_NEW}")
    set(CMAKE_CXX_FLAGS_DEBUG "${CMAKE_CXX_FLAGS_DEBUG_NEW}" PARENT_SCOPE)
  endif()
  if(ARGV1)
    message("-- Using verbose makefiles: ${ARGV0}")
    set(CMAKE_VERBOSE_MAKEFILE ${ARGV1})
    set(CMAKE_VERBOSE_MAKEFILE ${ARGV1} PARENT_SCOPE)
  endif()
  message("-- Using C compiler: ${CMAKE_C_COMPILER}")
  message("-- Using C++ compiler: ${CMAKE_CXX_COMPILER}")
  message("-- Using C compiler flags: ${CMAKE_C_FLAGS}")
  message("-- Using C++ compiler flags: ${CMAKE_CXX_FLAGS}")
  message("-- Using DEBUG C compiler flags: ${CMAKE_C_FLAGS_DEBUG}")
  message("-- Using DEBUG C++ compiler flags: ${CMAKE_CXX_FLAGS_DEBUG}")
  message("-- Using RELEASE C compiler flags: ${CMAKE_C_FLAGS_RELEASE}")
  message("-- Using RELEASE C++ compiler flags: ${CMAKE_CXX_FLAGS_RELEASE}")
  message("-- Using linker flags: ${CMAKE_EXE_LINKER_FLAGS}")
endfunction()

check_include_directory("/opt/include")
check_include_directory("/opt/lib")
check_include_directory("/opt/local/include")
check_include_directory("/opt/local/lib")
check_include_directory("/sw/include")
check_include_directory("/sw/lib")
check_include_directory("/usr/local/include" SYSTEM)
check_include_directory("/usr/local/lib")
check_include_directory("/usr/X11R6/include")
check_include_directory("/usr/X11R6/lib")

check_c_flag("-Werror=unused-command-line-argument" HAS_C_FLAG_WERROR_UNUSED_COMMAND_LINE_ARGUMENT)
check_cxx_flag("-Werror=unused-command-line-argument" HAS_CXX_FLAG_WERROR_UNUSED_COMMAND_LINE_ARGUMENT)
check_c_flag("-Werror=unknown-warning-option" HAS_C_FLAG_WERROR_UNKNOWN_WARNING_OPTION)
check_cxx_flag("-Werror=unknown-warning-option" HAS_CXX_FLAG_WERROR_UNKNOWN_WARNING_OPTION)

check_c_flag("-Werror=return-type" HAS_C_FLAG_WERROR_RETURN_TYPE)
check_cxx_flag("-Werror=return-type" HAS_CXX_FLAG_WERROR_RETURN_TYPE)

check_c_flag("-Werror-implicit-function-declaration" HAS_C_FLAG_WERROR_IMPLICIT_FUNCTION_DECLARATION)

check_cxx_flag("-Werror=non-virtual-dtor" HAS_CXX_FLAG_WERROR_NON_VIRTUAL_DTOR)

check_c_flag("-Wall" HAS_C_FLAG_WALL)
check_cxx_flag("-Wall" HAS_CXX_FLAG_WALL)
check_c_flag("-Wcast-align" HAS_C_FLAG_WCAST_ALIGN)
check_cxx_flag("-Wcast-align" HAS_CXX_FLAG_WCAST_ALIGN)
check_c_flag("-Wconversion" HAS_C_FLAG_WCONVERSION)
check_cxx_flag("-Wconversion" HAS_CXX_FLAG_WCONVERSION)
check_c_flag("-Wextra" HAS_C_FLAG_WEXTRA)
check_cxx_flag("-Wextra" HAS_CXX_FLAG_WEXTRA)
check_c_flag("-Winit-self" HAS_C_FLAG_WINIT_SELF)
check_cxx_flag("-Winit-self" HAS_CXX_FLAG_WINIT_SELF)
check_c_flag("-Winvalid-pch" HAS_C_FLAG_WINVALID_PCH)
check_cxx_flag("-Winvalid-pch" HAS_CXX_FLAG_WINVALID_PCH)
check_c_flag("-Wlogical-op" HAS_C_FLAG_WLOGICAL_OP)
check_cxx_flag("-Wlogical-op" HAS_CXX_FLAG_WLOGICAL_OP)
check_c_flag("-Wmissing-format-attribute" HAS_C_FLAG_WMISSING_FORMAT_ATTRIBUTE)
check_cxx_flag("-Wmissing-format-attribute" HAS_CXX_FLAG_WMISSING_FORMAT_ATTRIBUTE)
check_c_flag("-Wmissing-include-dirs" HAS_C_FLAG_WMISSING_INCLUDE_DIRS)
check_cxx_flag("-Wmissing-include-dirs" HAS_CXX_FLAG_WMISSING_INCLUDE_DIRS)
check_c_flag("-Wpacked" HAS_C_FLAG_WPACKED)
check_cxx_flag("-Wpacked" HAS_CXX_FLAG_WPACKED)
check_c_flag("-Wredundant-decls" HAS_C_FLAG_WREDUNDANT_DECLS)
check_cxx_flag("-Wredundant-decls" HAS_CXX_FLAG_WREDUNDANT_DECLS)
check_c_flag("-Wshadow" HAS_C_FLAG_WSHADOW)
check_cxx_flag("-Wshadow" HAS_CXX_FLAG_WSHADOW)
check_c_flag("-Wswitch-default" HAS_C_FLAG_WSWITCH_DEFAULT)
check_cxx_flag("-Wswitch-default" HAS_CXX_FLAG_WSWITCH_DEFAULT)
#check_c_flag("-Wswitch-enum" HAS_C_FLAG_SWITCH_ENUM)
#check_cxx_flag("-Wswitch-enum" HAS_CXX_FLAG_SWITCH_ENUM)
check_c_flag("-Wwrite-strings" HAS_C_FLAG_WWRITE_STRINGS)
check_cxx_flag("-Wwrite-strings" HAS_CXX_FLAG_WWRITE_STRINGS)
check_c_flag("-Wundef" HAS_C_FLAG_WUNDEF)
check_cxx_flag("-Wundef" HAS_CXX_FLAG_WUNDEF)

check_c_flag("-Wbad-function-cast" HAS_C_FLAG_WBAD_FUNCTION_CAST)
check_c_flag("-Wmissing-declarations" HAS_C_FLAG_WMISSING_DECLARATIONS)
check_c_flag("-Wmissing-prototypes" HAS_C_FLAG_WMISSING_PROTOTYPES)
check_c_flag("-Wnested-externs" HAS_C_FLAG_WNESTED_EXTERNS)
check_c_flag("-Wold-style-definition" HAS_C_FLAG_WOLD_STYLE_DEFINITION)
check_c_flag("-Wstrict-prototypes" HAS_C_FLAG_WSTRICT_PROTOTYPES)

check_cxx_flag("-Wctor-dtor-privacy" HAS_CXX_FLAG_WCTOR_DTOR_PRIVACY)
check_cxx_flag("-Wold-style-cast" HAS_CXX_FLAG_WOLD_STYLE_CAST)
check_cxx_flag("-Woverloaded-virtual" HAS_CXX_FLAG_WOVERLOADED_VIRTUAL)

check_c_flag("-fdiagnostics-show-option" HAS_C_FLAG_WDIAGNOSTICS_SHOW_OPTION)
check_cxx_flag("-fdiagnostics-show-option" HAS_CXX_FLAG_WDIAGNOSTICS_SHOW_OPTION)
check_c_flag("-ftracer" HAS_C_FLAG_FTRACER)
check_cxx_flag("-ftracer" HAS_CXX_FLAG_FTRACER)
check_c_flag("-fweb" HAS_C_FLAG_FWEB)
check_cxx_flag("-fweb" HAS_CXX_FLAG_FWEB)
check_c_flag("-pipe" HAS_C_FLAG_PIPE)
check_cxx_flag("-pipe" HAS_CXX_FLAG_PIPE)

#check_c_flag("-g" HAS_C_FLAG_G "DEBUG")
#check_cxx_flag("-g" HAS_CXX_FLAG_G "DEBUG")
check_c_flag("-O0" HAS_C_FLAG_O0 "DEBUG")
check_cxx_flag("-O0" HAS_CXX_FLAG_O0 "DEBUG")
check_c_flag("-funit-at-a-time" HAS_C_FLAG_FUNIT_AT_A_TIME "DEBUG")
check_cxx_flag("-funit-at-a-time" HAS_CXX_FLAG_FUNIT_AT_A_TIME "DEBUG")

#check_c_flag("-O3" HAS_C_FLAG_O3 "RELEASE")
#check_cxx_flag("-O3" HAS_CXX_FLAG_O3 "RELEASE")
check_c_flag("-ffast-math" HAS_C_FLAG_FFAST_MATH "RELEASE")
check_cxx_flag("-ffast-math" HAS_CXX_FLAG_FFAST_MATH "RELEASE")
check_c_flag("-fgcse-las" HAS_C_FLAG_FGCSE_LAS "RELEASE")
check_cxx_flag("-fgcse-las" HAS_CXX_FLAG_FGCSE_LAS "RELEASE")
check_c_flag("-fgcse-sm" HAS_C_FLAG_FGCSE_SM "RELEASE")
check_cxx_flag("-fgcse-sm" HAS_CXX_FLAG_FGCSE_SM "RELEASE")
check_c_flag("-fomit-frame-pointer" HAS_C_FLAG_FOMIT_FRAME_POINTER "RELEASE")
check_cxx_flag("-fomit-frame-pointer" HAS_CXX_FLAG_FOMIT_FRAME_POINTER "RELEASE")
check_c_flag("-fsee" HAS_C_FLAG_FSEE "RELEASE")
check_cxx_flag("-fsee" HAS_CXX_FLAG_FSEE "RELEASE")
check_c_flag("-fsingle-precision-constant" HAS_C_FLAG_FSINGLE_PRECISION_CONSTANT "RELEASE")
check_cxx_flag("-fsingle-precision-constant" HAS_CXX_FLAG_FSINGLE_PRECISION_CONSTANT "RELEASE")
