/**
 * ...
 * @author Henri Sarasvirta
 */

(function() {
	var Earth = function(main, id){
		this.Id = id;
		this.main = main;
	}
	var p = Earth.prototype = new wideload.BasePart();
	wideload.Earth = Earth;
	
	p.superInitialize = p.initialize;

	p.initialize = function(scene,container){
		this.superInitialize(scene,container);
		
		this.container.position.x = 0;
		this.container.position.y = 0
		//this.container.position.z = -200;
		this.trees = [];
		for(var i = 0; i < 1; ++i){
			this.trees[i] = new wideload.Tree(this.main, "");
			this.trees[i].initialize(scene, new THREE.Object3D());
			//this.trees[i].container.position = new THREE.Vector3(-2,5,2400);
			//this.container.add(this.trees[i].container);
		}

		var grassMaterial = new THREE.ShaderMaterial( {
			fragmentShader: wideload.EarthShader.fragment,
			vertexShader: wideload.EarthShader.vertex,
			uniforms: wideload.EarthShader.uniforms,
		//	depthWrite: false
		});
		
		var tex = new THREE.Texture(Asset.getAsset("grass"));
		tex.wrapS = tex.wrapT = THREE.RepeatWrapping; 
		tex.needsUpdate = true;
		var hm = new THREE.Texture(Asset.getAsset("hm_ground"));
		hm.wrapS = hm.wrapT = THREE.RepeatWrapping; 
		hm.needsUpdate = true;
		
		var normal = new THREE.Texture(Asset.getAsset("grassNormals"));
		normal.wrapS = normal.wrapT = THREE.RepeatWrapping; 
		normal.needsUpdate = true;
		
		
		grassMaterial.uniforms.normal.value = normal;
		grassMaterial.uniforms.texture.value = tex;
		grassMaterial.uniforms.heightmap.value = hm;
		
		mirrorMesh = new THREE.Mesh(
					new THREE.PlaneGeometry( 5000 , 5000, 120, 120 ), 
					grassMaterial
				);
		
		mirrorMesh.rotation.x = - Math.PI * 0.5;
		this.container.add( mirrorMesh );
		
		this.container.position.y = -34;
		
	}
	
	p.internalUpdate = function(elapsedtime,partial){
		if(this.startTime + 8000 > elapsedtime)
		{
			this.container.visible = false;
		}
		else
		{
			this.container.visible = true;
		}
		for(var i = 0; i < this.trees.length; ++i){
			this.trees[i].update(elapsedtime, partial);
		}
		//THREE.AnimationHandler.update( elapsedtime );
	//	var delta = this.main.clock.getDelta();
    //	var theta = this.main.clock.getElapsedTime();
		//this.animation.update(delta);
//		this.water.material.uniforms.time.value += 1.0 / 90.0;
		//this.main.renderer.render( this.main.scene, this.main.camera );
	//	THREE.AnimationHandler.update( delta );
	}
	
})();
