/**
 * ...
 */

(function() {
	var Dream = function(main, id){
		this.Id = id;
		this.main = main;
	}
	var p = Dream.prototype = new wideload.BasePart();
	wideload.Dream = Dream;
	
	p.superInitialize = p.initialize;

	p.initialize = function(scene, container){
		this.superInitialize(scene,container);


		this.dreamwords = new wideload.DreamWord(this.main, "");
		var words = new THREE.Object3D();
		this.dreamwords.initialize(scene,words);
		this.dreamwords.start();
		this.renderTarget = new THREE.WebGLRenderTarget( 1024, 1024, { minFilter: THREE.LinearFilter, magFilter: THREE.NearestFilter, format: THREE.RGBAFormat } );	

		this.container.add(words);
		// Skybox	
		var geo = new THREE.SphereGeometry(1000,32,32);
		var material = new THREE.MeshBasicMaterial({map:this.renderTarget, side:THREE.DoubleSide, color:0x585858});
		this.sphere = new THREE.Mesh(geo, material);
		
		this.container.add(this.sphere);

		var loader = new THREE.OfflineJSONLoader();
		
		var container = this.container;
		var dudes = [];
		var animations = [];
		var spiders = [];
		var spiderAnimations = [];
		container.add(new THREE.AmbientLight(0xffffff));
		loader.load(jsAsset_spider, function( geo, materials ) {
			
  			for (var i = 0; i < materials.length; i++) {
    			var mat = materials[i];
    			//mat.color = 0xffffff;
    			mat.skinning = true;
    			mat.needsUpdate = true;

  			}
  			for(var i = 0; i < 10; ++i){
  					
  					var m = materials[0].clone();
  					var spider = new THREE.SkinnedMesh(
    					geo,
    					new THREE.MeshFaceMaterial([m]));
  					spiders.push(spider);
    				spider.position.x = wideload.Random.nextFloat()*10-5;
    				spider.position.y = wideload.Random.nextFloat()*30-20;
    				spider.position.z = wideload.Random.nextFloat()*10-5;

    				spider.rotation.x = wideload.Random.nextFloat();
    				spider.rotation.y = wideload.Random.nextFloat();
    				spider.rotation.z = wideload.Random.nextFloat();
    				spider.direction = new THREE.Vector3(wideload.Random.nextFloat()-wideload.Random.nextFloat(),wideload.Random.nextFloat(),wideload.Random.nextFloat()-wideload.Random.nextFloat());
    				
    				container.add(spider);

    				//THREE.AnimationHandler.add( dude.geometry.animations[ 0 ] );
    				var data = spider.geometry.animations[ 0 ];
    				data.initialized = false;
    				//data.name += "" + j +i;
  					var animation = new THREE.Animation(spider,data);
  					animation.play(i/10);
  					spiderAnimations.push(animation);  
			//createjs.Tween.get(spider.position).to({x:-spider.position.x, y:-spider.position.y, z: -spider.position.z}, 35500, createjs.Ease.circOut);
  				}

		});
	this.spiders = spiders;
	this.spiderAnimations = spiderAnimations;
		loader.load(jsAsset_DreamDude, function( geo, materials ) {
  			
  			for (var i = 0; i < materials.length; i++) {
    			var mat = materials[i];
    			//mat.color = 0xffffff;
    			mat.skinning = true;
    			mat.needsUpdate = true;

  			}
  			var d = 0;
  			var r = 50;
  			for(var j = 0; j < 10;++j){
  				for(var i = 0; i < 10; ++i){
  					
  					d+= 4*Math.PI/100;
  					var m = materials[0].clone();
  					var dude = new THREE.SkinnedMesh(
    					geo,
    					new THREE.MeshFaceMaterial([m]));
    				dude.position.z = 0;
    				dude.position.x = Math.sin(d)*r;
    				dude.position.y = Math.cos(d)*r;
    				dude.position.z = Math.cos(d)*r
    				
    				dude.rotation.z = d;

    				r-= 0.3;
    				dudes.push(dude);
    				container.add(dude);
    				//THREE.AnimationHandler.add( dude.geometry.animations[ 0 ] );
    				var f = 0xff;
    				var c = (j*10+i)/25;
    				
    				var jex = c*f%255;

    				var hex = (jex << 16) | ((255-jex) << 8) | (jex);
    				dude.material.materials[0].color.setHex(~hex);
    				dude.c = c;
    				var data = dude.geometry.animations[ 0 ];
    				data.initialized = false;
    				//data.name += "" + j +i;
    				dude.visible = false;
  					var animation = new THREE.Animation(dude,data);
  					animation.play(-d/2);
  					animations.push(animation);  
			
  				}
  			}

		});

		this.dudes = dudes;
		this.animations = animations;
		this.allDudesVisible = false;
		
		this.dudeIndex = 0;

		//dude.castShadow = true;
//		dude.material.materials[0].envmap = new THREE.CubeTexture( [Asset.getAsset("skybox"),Asset.getAsset("skybox"),Asset.getAsset("skybox"),Asset.getAsset("skybox"),Asset.getAsset("skybox"),Asset.getAsset("skybox")] );
		
  		

  		//THREE.AnimationHandler.add( dude.geometry.animations[ 0 ] );
  		//this.animation = new THREE.Animation(dude,dude.geometry.animations[ 0 ]);
  		//this.animation.play();
  		this.main.camera.position.z = 5010;
  		this.main.camera.lookAt(new THREE.Vector3(0,0,0));
	}

	
	p.internalUpdate = function(elapsedtime,renderTarget){
		var delta = renderTarget;
		//var delta = this.main.clock.getDelta();
		//this.spiderAnimation.update(delta);
		var d = this.main.clock.getDelta();
		//this.spidu.rotation.z += 0.005;
		//THREE.AnimationHandler.update( delta );
		for(var i = 0; i < this.animations.length; ++i){
			this.animations[i].update(d);
		}
		for(var i = 0; i < this.spiderAnimations.length; ++i){
			this.spiderAnimations[i].update(d);
		}
		for(var i = 0; i < this.spiders.length; ++i){
			var spid = this.spiders[i];
			
			spid.position.add(spid.direction);
		}
		if(!this.allDudesVisible){
			for(var i = 0; i < this.dudes.length; ++i){
				if(i == this.dudes.length-1){
					this.allDudesVisible = true;
				}
				if(this.dudes[i].visible == false){
					this.dudes[i].visible = true;
					break;
				}
			}
		}
		else{
    		this.dudes[this.dudeIndex].material.materials[0].color.setHex(~this.dudes[this.dudeIndex].material.materials[0].color.getHex());
    				//this.dudes[this.dudeIndex].c = c;
			this.dudeIndex++;
			if(this.dudeIndex == this.dudes.length){
				this.dudeIndex = 0;
			}
			for(var i = 0;i< this.dudes.length;++i){
				this.dudes[i].position.z += i*0.01;
			}
		}

		this.dreamwords.update(elapsedtime,renderTarget);
		this.main.renderer.render(this.main.scene, this.main.camera,this.renderTarget);
		

		this.sphere.rotation.z = 20*delta;
		this.sphere.rotation.y = 15*delta;
		this.sphere.rotation.x = 23*delta;
		//this.animation.update(delta);

	}
})();