﻿//Line drwawings


//duration: part length in ms
//startTime: the absolute time when the part starts
//endTime: time that part need for end effect in ms
var Towers = function(){
  PartBase.call(this);
  this.initScene();
}

Towers.prototype = PartBase.prototype.inheritance();

//scene is initialized before demo starts
Towers.prototype.initScene = function(){
  
  this.scene = new THREE.Scene();
  this.camera = new THREE.PerspectiveCamera(TDEMO.fov, TDEMO.aspect, TDEMO.near, TDEMO.far);
  this.camera.position.z = 450;
  this.camera.position.y = 100;
  this.camera.rotation.x = -Math.PI/6;
  //this.camera.lookAt(new THREE.Vector3(0,0,0));
  this.scene.add(this.camera);
  
  this.extrusions = [];
  this.texts = [];
  
  this.createTowers();
  this.createSurroundings();
}

//rendering function
Towers.prototype.render = function(elapsedTime, rtt){
  TDEMO.renderer.render(this.scene, this.camera, rtt);
};

//Operations tahta takes place before rendering in every cycle
Towers.prototype.animate = function(elapsedTime){
  for(var i = 0; i < this.transformations.length; ++i){
    var transform = this.transformations[i];
    if(!transform.done && elapsedTime >= transform.start && elapsedTime <= transform.end){
      transform.callback.call(this, transform, elapsedTime);
    }
    else if(!transform.done && elapsedTime >= transform.end){
      transform.done = true;
    }
  }
};

Towers.prototype.createText = function(txt) {
  // In goes string, out comes Mesh 
  var material = new THREE.MeshFaceMaterial( [
    new THREE.MeshBasicMaterial( { color: 0x666688, shading: THREE.FlatShading, opacity: 0.8 } ),
    new THREE.MeshLambertMaterial( { 
      color: 0x4466FF} )
  ] );
  var options = {
    size: 8,
    height: 12,
    curveSegments: 16,
    font: "helvetiker",
    
    bevelEnabled: true,
    bevelThickness: 2,
    bevelSize: 2,

    material: 0,
    extrudeMaterial: 1
  };
  var text3d = new THREE.TextGeometry(txt, options);
  text3d.computeVertexNormals();
  text3d.computeBoundingBox();
  tmp = new THREE.Mesh(text3d, material);
  return tmp;
}

//prepare function that is called before first rendering
Towers.prototype.prepare = function(elapsedTime, rtt){
  this.startTime = elapsedTime;
  
  this.transformations = [
    {
      start: this.startTime,
      end : this.startTime + TDEMO.barLength*4,
      v : 10/(TDEMO.barLength*4),
      vc : (200-450)/(TDEMO.barLength*4),
      p : 0.1,
      c: 450,
      callback : function(transform, time){
        var t = time - transform.start;
        var s = transform.v * t;
        this.extrusions[0].scale.z = s+transform.p;
        this.extrusions[1].scale.z = s+transform.p;
        this.texts[0].position.y = 2+this.extrusions[0].scale.z * 10
        this.texts[1].position.y = 2+this.extrusions[1].scale.z * 10

        var sc = transform.vc * t;
        this.camera.position.z = sc+transform.c;
        this.pointLight.position.z = this.camera.position.z+100;
      },
      done : false
    },
    {
      start: this.startTime + TDEMO.barLength*4,
      end : this.startTime + TDEMO.barLength*7,
      v : 10/(TDEMO.barLength*3),
      vc : (-200)/(TDEMO.barLength*3),
      p : 0.1,
      c: 200,
      callback : function(transform, time){
        var t = time - transform.start;
        var s = transform.v * t;
        this.extrusions[2].scale.z = s+transform.p;
        this.extrusions[3].scale.z = s+transform.p;
        this.texts[2].position.y = 2+this.extrusions[2].scale.z * 10
        this.texts[3].position.y = 2+this.extrusions[3].scale.z * 10
        
        var sc = transform.vc * t;
        this.camera.position.z = sc+transform.c;
        this.pointLight.position.z = this.camera.position.z+100;
      },
      done : false
    },
    {
      start: this.startTime + TDEMO.barLength*7,
      end : this.startTime + TDEMO.barLength*10,
      v : 10/(TDEMO.barLength*3),
      vc : (-200)/(TDEMO.barLength*3),
      p : 0.1,
      c: 0,
      callback : function(transform, time){
        var t = time - transform.start;
        var s = transform.v * t;
        this.extrusions[4].scale.z = s+transform.p;
        this.extrusions[5].scale.z = s+transform.p;
        this.texts[4].position.y = 2+this.extrusions[4].scale.z * 10
        this.texts[5].position.y = 2+this.extrusions[5].scale.z * 10
        
        var sc = transform.vc * t;
        this.camera.position.z = sc+transform.c;
        this.pointLight.position.z = this.camera.position.z+100;
      },
      done : false
    },
  ];
};

Towers.prototype.createTowers = function(){
  // this.lsys.interpret(1, 90, "FFFFFF", "FrFlFrFrFlFlFFrFl",1);
  //this.lsys.interpret(1, 90, "FrFrFrF", "rFFlF",3);
  var extrudeMaterial = new THREE.MeshPhongMaterial({
    color : 0x236B8E,
    ambient : 0x6A5ACD,
    emissive : 0x000000,//0x855285,
    specular : 0xFF55FF
  });
  
  //Creating first tower
  var lsys = new LSYSTEM();
  lsys.interpret(1, 90, "FrFrFrF", "FrFlFlFFrFrFlF",3);
  lsys.moveToCenter();
  var lsline = lsys.createLine(new THREE.LineBasicMaterial());

  var p = new THREE.Path(lsline.geometry.vertices);
  var s = p.toShapes()[0];
  var extGeometry = s.extrude({
    steps : 1,
    bevelEnabled : false,
    amount: 10
  });
  
  var amount = 3;
  var z = 200;
  var step = -200;
  
  var greetz = ["Wide Load", "Nalleperhe", "Compocrew", "Bilotrip", "Demokerho", "<3"]

  var j = 0;
  for(var i = 0; i < amount; ++i){
  
    var m = new THREE.Mesh(extGeometry, extrudeMaterial);
    m.scale.z = 0.1;
    m.position.x = -100;
    m.position.z = z;
    m.rotation.x = -Math.PI/2;
    var g = this.createText(greetz[j]);
    j = j+1;
    g.position.x = -100 - (g.geometry.boundingBox.max.x / 2)
    g.position.z = z-12;
    g.position.y += 2
    g.rotation.x = -Math.PI / 20;
    g.rotation.y = Math.PI / 10;
    this.texts.push(g);
    this.scene.add(g)

    var m2 = new THREE.Mesh(extGeometry, extrudeMaterial);
    m2.scale.z = 0.1;
    m2.position.x = 100;
    m2.position.z = z;
    m2.rotation.x = -Math.PI/2;
    var g2 = this.createText(greetz[j]);
    j = j+1;
    g2.position.x = 100 - (g2.geometry.boundingBox.max.x / 2)
    g2.position.z = z-12;
    g2.position.y += 2
    g2.rotation.x = -Math.PI / 20;
    g2.rotation.y = -Math.PI / 10;
    this.texts.push(g2);
    this.scene.add(g2)
    
    this.extrusions.push(m);
    this.scene.add(m);
    this.extrusions.push(m2);
    this.scene.add(m2);
    
    z += step;
  }
  
  
}

Towers.prototype.createSurroundings = function(){
  var dirLight = new THREE.DirectionalLight(0xAAAAFF, 10);
  dirLight.position.set(0, 50, 10);
  dirLight.target.position.set(0,0,0);

  var ambient = new THREE.AmbientLight(0xFFAAFF);
  this.scene.add(ambient);
  this.scene.add(dirLight);
  this.pointLight = new THREE.PointLight(0xBF5FFF);
  this.pointLight.position.z = this.camera.position.z+100;
  this.pointLight.position.y = this.camera.position.y+10;
  this.scene.add(this.pointLight);
  this.scene.fog = new THREE.Fog(0x8F8FBC, 200.0, 800 );

  var skyMaterial = new THREE.MeshLambertMaterial({
    color : 0x7171C6,
    side: THREE.BackSide
  });
  this.skySphere = new THREE.Mesh(new THREE.SphereGeometry(800, 16, 16), skyMaterial);
  this.skySphere.rotation.y = -Math.PI/4;
  this.scene.add(this.skySphere);
  
};
