﻿
//Line drwawings by rimina

//duration: part length in ms
//startTime: the absolute time when the part starts
//endTime: time that part need for end effect in ms
var Lines = function(){
  PartBase.call(this);
  this.initScene();
}

Lines.prototype = PartBase.prototype.inheritance();

//scene is initialized before demo starts
Lines.prototype.initScene = function(){
  
  this.scene = new THREE.Scene();
  this.camera = new THREE.PerspectiveCamera(TDEMO.fov, TDEMO.aspect, TDEMO.near, TDEMO.far);
  this.camera.position.z = 450;
  this.scene.add(this.camera);
  this.lines = new THREE.Object3D();
  this.lineMaterial = new THREE.LineBasicMaterial({ color: /*0xFF83FA*/0xFFFFFF});
  this.lineMaterial2 = new THREE.LineBasicMaterial({ color: /*0xBA55D3*/0xBBFFFF});
  
  //this.lineMaterial.vertexColors = THREE.VertexColors;
  //this.lineMaterial2.vertexColors = THREE.VertexColors;
  
  this.lsystem = new LSYSTEM();
  
  this.lsystem.interpret(9, 90, "FrFrFruFuFuFulFlFl","FuFrFFtFrFlF", 4);
  this.lsystem.moveToCenter();

  this.line = this.lsystem.createLine(this.lineMaterial);
  this.line.position.x = 10;
  this.lines.add(this.line);
  
  
  this.line2 = new THREE.Line(this.line.geometry, this.lineMaterial2);
  this.line2.position.x = -10;
  this.lines.add(this.line2);
  
  this.lines.position.z = this.lsystem.center.z;
  this.scene.add(this.lines);
  
  
  this.startTime = 0;
  this.transformations = [];
  
  this.createSurroundings();
}

Lines.prototype.prepare = function(elapsedTime){
  this.startTime = elapsedTime;
  
  this.transformations = [
    {
      start : this.startTime,
      end : this.startTime + TDEMO.barLength*21,
      v : (Math.PI*2.7)/(21*TDEMO.barLength),
      callback : function(transform, time){

        var t = time - transform.start;
        var s = transform.v * t;
        
        this.line.rotation.y = s;
        this.line.rotation.x = -s;
        this.line.rotation.z = s;
        this.line2.rotation.y = -s;
        this.line2.rotation.x = s;
        this.line2.rotation.z = -s;
        
      },
      done : false
    },
    {
      start : this.startTime + TDEMO.barLength*2,
      end : this.startTime + TDEMO.barLength*20,
      p : 450,
      v : (-260-450)/(18*TDEMO.barLength),
      callback: function(transform, time){
        var t = time - transform.start;
        var s = transform.v*t;
        
        this.camera.position.z = transform.p+s;
      },
      done: false
    },
  ];
};

//Operations tahta takes place before rendering in every cycle
Lines.prototype.animate = function(elapsedTime){

  for(var i = 0; i < this.transformations.length; ++i){
    var transform = this.transformations[i];
    if(!transform.done && elapsedTime >= transform.start && elapsedTime <= transform.end){
      transform.callback.call(this, transform, elapsedTime);
    }
    else if(!transform.done && elapsedTime >= transform.end){
      transform.done = true;
    }
  }
  
  this.cloudUniforms.time.value = (elapsedTime*0.3);
}

Lines.prototype.createSurroundings = function(){

  this.scene.fog = new THREE.Fog(0x6B238E, 300, 580);
  
  this.cloudUniforms = { 
    time    : { type : "f", value:  0.0 },
    opacity : { type : "f", value:  1.0 },
    c0      : { type : "f", value:  0.5 },
    c1      : { type : "f", value:  0.1 },
    c2      : { type : "f", value:  1.0 },
    c3      : { type : "f", value:  0.4 },
    c4      : { type : "f", value:  0.1 },
    c5      : { type : "f", value:  0.7 },
    fogColor: { type: "c", value: this.scene.fog.color },
    fogNear : { type: "f", value: 300.0 },
    fogFar  : { type: "f", value: 600.0 },
  };
  var cloudMaterial = new THREE.ShaderMaterial({uniforms: this.cloudUniforms,
      vertexShader: document.getElementById('vertex').textContent,
      fragmentShader: document.getElementById('plasma').textContent,
      side: THREE.BackSide,
      fog: true,
  });

  this.skySphere = new THREE.Mesh(new THREE.SphereGeometry(500, 16, 16), cloudMaterial);
  this.scene.add(this.skySphere);
  
  /*var hsl = this.lineMaterial.color.getHSL();
  var hsl2 = this.lineMaterial2.color.getHSL();
  
  for(var i = 0; i < this.line.geometry.vertices.length; ++i){
    hsl.l -= i/this.line.geometry.vertices.length;
    var color = new THREE.Color()
    color.setHSL(hsl.h, hsl.s, hsl.l);
    this.line.geometry.colors.push(color);
    
    hsl2.s += i/this.line2.geometry.vertices.length;
    var color2 = new THREE.Color()
    color2.setHSL(hsl2.h, hsl2.s, hsl2.l);
    this.line2.geometry.colors.push(color2);
    
    console.log(color);
    console.log(color2);
  }
  this.line.geometry.colorsNeedUpdate= true;
  this.line2.geometry.colorsNeedUpdate= true;*/
  
}

//color converters from http://www.cs.rit.edu/~ncs/color/t_convert.html
Lines.prototype.hsvToRgb = function(h, s, v){

  var r, g, b, f, p, q, t, i = 0;
	
	if( s == 0 ) {
		// achromatic (grey)
		r = g = b = v;
	}
  else{
    h /= 60;			// sector 0 to 5
    i = Math.floor( h );
    f = h - i;			// factorial part of h
    p = v * ( 1 - s );
    q = v * ( 1 - s * f );
    t = v * ( 1 - s * ( 1 - f ) );
    switch( i ) {
      case 0:
        r = v;
        g = t;
        b = p;
        break;
      case 1:
        r = q;
        g = v;
        b = p;
        break;
      case 2:
        r = p;
        g = v;
        b = t;
        break;
      case 3:
        r = p;
        g = q;
        b = v;
        break;
      case 4:
        r = t;
        g = p;
        b = v;
        break;
      default:		// case 5:
        r = v;
        g = p;
        b = q;
        break;
    }
  }
  
  return {r:r, g:g, b:b};
  
}

//color converters from http://www.cs.rit.edu/~ncs/color/t_convert.html
Lines.prototype.rgbToHsv = function(r, g, b){
  var h = 0;
  var s = 0;
  var v = 0;
  
  console.log(r + " " +g + " "+b);
  var min = Math.min(r, g, b);
  var max = Math.max(r, g, b);
  
  v = max;
  
  var delta = max-min;
  
  if(max != 0){
    s = delta/max;
  }
  else{
    s = 0;
    h = -1;
    
    return {h : h, s: s, v: undefined}
  }
  if(r == max){
    h = (g-b)/delta;
  }
  else if(g == max){
    h = 2 + ( b - r ) / delta;
  }
  else{
    h = 4 + ( r - g ) / delta;
  }
  
  h *= 60;
	if( h < 0 ){
    h += 360;
  }
  return {h:h, s:s, v:v};
}

//rendering function
Lines.prototype.render = function(elapsedTime, rtt){
  TDEMO.renderer.render(this.scene, this.camera, rtt);
}