#version 330 core

// Input vertex data, different for all executions of this shader.
layout(location = 0) in vec3 particle_vertex;
layout(location = 1) in vec2 particle_index;
layout(location = 2) in vec4 particle_color;

// Output data ; will be interpolated for each fragment.
out vec2 UV;
out vec4 color;
out vec2 pdx;

// Values that stay constant for the whole mesh.
uniform sampler2D particlepos_tex;
uniform mat4 P;
uniform mat4 V;
uniform vec3 camRight;
uniform vec3 camUp;

mat3 rotationMatrix(vec3 axis, float angle) {
    axis = normalize(axis);
    float s = sin(angle);
    float c = cos(angle);
    float oc = 1.0 - c;
    
    return mat3(oc * axis.x * axis.x + c,           oc * axis.x * axis.y - axis.z * s,  oc * axis.z * axis.x + axis.y * s,
                oc * axis.x * axis.y + axis.z * s,  oc * axis.y * axis.y + c,           oc * axis.y * axis.z - axis.x * s,
                oc * axis.z * axis.x - axis.y * s,  oc * axis.y * axis.z + axis.x * s,  oc * axis.z * axis.z + c);
}

void main(){
//	gl_Position =  vec4(particle_vertex.x * camRight.xy + particle_vertex.y * camUp.xy, 0.0, 1.0) + vec4(0.0) * P * vec4(particle_center.xyz + particle_vertex.x * particle_center.w * camRight + particle_vertex.y * particle_center.w * camUp, 1.0);
	vec4 particle_center = texture(particlepos_tex, particle_index);
	float scalefactor = -4.0 * particle_center.a * (particle_center.a - 1.0);
	vec4 particle_pos = vec4(vec3(particle_center.xyz + 0.6*scalefactor* (particle_vertex.x * camRight + particle_vertex.y * camUp)), 1.0);
//	particle_pos.xy *= 2.0;
	gl_Position = P * particle_pos;
	
	// UV of the vertex. No special space for this one.
	UV = particle_vertex.xy + vec2(0.5);
	color = vec4(particle_center.w);
	pdx = particle_index;
	//color.rgb = particle_center.rgb
}

