#version 330 core

in vec2 UV;
in vec4 color;
in vec2 pdx;
uniform sampler2D particle;
uniform sampler2D particlecol;
uniform sampler2D fft;
// uniform float fftcoef;
uniform int rendertype;

out vec4 oColor;

void main(){
	if (rendertype == 0) {
	    oColor = texture(particle, UV) * (vec4(1.0) - vec4(0.1,0.2,0.02,0.0)) * vec4(0.7,1.0,1.0,1.0);
	    oColor.a *= 3.0*0.0125;
	    //oColor.xyz = vec4(1.0,0.0,1.0,1.0).xyz;
	} else if (rendertype == 1) {
	    oColor = texture(particle, UV) * texture(particlecol, pdx);// * vec4(0.1,1.0,1.0,1.0);
	    // oColor.x = smoothstep(); // zero
	    oColor.y = smoothstep(0.05, 1.20, oColor.y);
	    oColor.z = smoothstep(0.10, 1.15, oColor.z);
	    oColor.w *= 0.25;
	} else {
		// fft stuff
		float freq = texture(fft, vec2(0.2*pdx.x, 0.0)).r;
	    oColor = texture(particle, UV) * (vec4(1.0) - vec4(0.1,0.2,0.02,0.0)) * vec4(0.7,1.0,1.0,1.0);
	    oColor.a *= 3.0*0.0125;
	    oColor.a *= 500.0*max(freq, 1e-4);
	}
}
