#version 330 core

in vec2 UV;
in vec3 normal;
in vec4 pos;
in vec3 origpos;
in vec4 MVpos;

// Values that stay constant for the whole mesh.
uniform sampler2D myTextureSampler;

// output
layout(location = 0) out vec4 color;


const vec3 lightpos = vec3(2.4, -1.0, -2.0);

void main(){
	vec3 lightdir = normalize(pos.xyz - lightpos);
	float ct = pow(max(dot(normal, lightdir), 0.0), 5.0) / (length(lightpos - pos.xyz)*0.25) * 0.00001;
	ct += (1.0 - pow( max(dot(normalize(-MVpos.xyz), normal), 0.0), 1.05 )) / (length(lightpos - pos.xyz)*0.2525);

	if (ct < 0.7) ct = 0.0;
	ct = smoothstep(0.7, 0.9, ct);
	color = vec4(ct,ct,ct,1.0);
	color.x = smoothstep(0.11, 0.95, color.x);
	color.y = smoothstep(0.12, 0.85, color.x)+0.001;
	color.z = smoothstep(0.25, 0.70, color.x);
	color *= color;
	color += vec4(vec3(0.005),0.0);
//	color = 0.00001 * color;
}
