varying vec3 v_normal;
varying vec3 v_look;

void main()
{
	v_normal = normalize(gl_NormalMatrix * gl_Normal);
	vec4 pos = gl_ModelViewMatrix * gl_Vertex;
	v_look = vec3(normalize(pos));
	gl_Position = ftransform();
}

//____FRAGMENT_SHADER____

varying vec3 v_normal;
varying vec3 v_look;

uniform sampler2D u_envitex;


vec2 envCoord(vec3 u, vec3 n) 
{
	vec2 e;
	vec3 r = reflect(u, n);
	float m = 0.5 / sqrt(r.x * r.x + r.y * r.y + (r.z + 1.0) * (r.z + 1.0));
	e.x = r.x * m + 0.5;
	e.y = r.y * m + 0.5;
	return e;
}


void main()
{
	gl_FragColor = texture2D(u_envitex, envCoord(v_look, v_normal));
}
