var MetaBot = (function () {

	"use strict";

	var _model,
		_duration = 0,
		_sync,
		_width,
		_height,
		_ctx,
		_preflightCallback,
		_d,
		_m,
        _s,
		_bctx,
        _sctx;

	var _blackFade,
		_glow,
        _sAlpha,
		_botHeadY,
		_botTorsoY,
		_botLegY;

	function preflight(callbackFn, duration, model) {
		_preflightCallback = callbackFn;

		_duration = duration;
		_model = model;

		_sync = _model.sync;
		_width = _model.width();
		_height = _model.height();

		initSync();

		_ctx = _model.twoDeeRenderer;

		_preflightCallback();
	}

	function init() {
		_model.on("resize", resize);

		Random.seed(42424242, 8000085, 1333337, 4242424);

		_bctx  = document.createElement('canvas').getContext('2d');
		_bctx.canvas.width = _width / 4;
		_bctx.canvas.height = _height / 4;

        _sctx  = document.createElement('canvas').getContext('2d');
        _sctx.canvas.width = _width / 2;
        _sctx.canvas.height = _height / 2;

		_d = new Dither();
		_d.setFillColor('#1f1f1f');
		_d.setContextInput(_bctx);
		_d.setContext(_ctx);

		_m = new MetaBalls();
		_m.setTextureArray([Meat.mBlob1]);//, _img, _img]);
		_m.setContext(_bctx);

        _s = new Starfield();
        _s.setContext(_sctx);
        _s.setCenter(_width *.5, _height *.25);
	}

	function initSync() {
		_blackFade = _sync.getTrack('blackFade');
		_glow = _sync.getTrack('glow');
        _sAlpha = _sync.getTrack('0:sAlpha');
		_botHeadY = _sync.getTrack('botHeadY');
		_botTorsoY = _sync.getTrack('botTorsoY');
		_botLegY = _sync.getTrack('botLegY');

	}

	function render(row, sceneTime, frameDelta) {
		_ctx.fillStyle = '#f6c003';
		_ctx.fillRect(0, 0, _width, _height);

		_ctx.save();
		_ctx.globalAlpha = .8;
		_ctx.drawImage(Meat.pattern, 0, (_height - (Meat.pattern.height / 1080 * _height)) * 0.5, Meat.pattern.width / 1920 * _width, Meat.pattern.height / 1080 * _height);
		_ctx.restore();

		_bctx.clearRect(0,0,_bctx.canvas.width, _bctx.canvas.height);
		_m.render(frameDelta *0.1);
		//_ctx.drawImage(_bctx.canvas,0,0);
		_d.render();

        var sAlpha = _sAlpha.getValue(row);
        if(sAlpha > 0){
            _ctx.save();
            _s.setCenter(_width *.5, _height *.25);
            _sctx.clearRect(0,0,_width *.5,_height *.5);
            _s.render(frameDelta *.01);
            _sctx.globalAlpha = sAlpha;
            //_ctx.globalCompositeOperation = 'color-dodge';
            _ctx.drawImage(_sctx.canvas, 0,0, _width,_height);
            _ctx.restore();
        }

		_ctx.drawImage(Meat.iFlyVertical, 0, _height - (Meat.iFlyVertical.height/1080*_height), Meat.iFlyVertical.width/1920 * _width, Meat.iFlyVertical.height/1080*_height);

		var _botX = 777 / 1920 * _width,
			_botY = 254 / 1080 * _height;

		var headY = _botHeadY.getValue(row) / 1080 * _height,
			torsoY = _botTorsoY.getValue(row) / 1080 * _height,
			legY = _botLegY.getValue(row) / 1080 * _height;

		_ctx.drawImage(Meat.botHead, _botX + (470 /1920 * _width), _botY + headY,
										Meat.botHead.width/1920 * _width, Meat.botHead.height/1080 * _height);

		_ctx.drawImage(Meat.botMiddle, _botX, _botY + (156 /1080 * _height) + torsoY,
										Meat.botMiddle.width/1920 * _width, Meat.botMiddle.height/1080*_height);

		_ctx.drawImage(Meat.botBottom, _botX + (389 /1920 * _width), _botY + (510 /1080 * _height) + legY,
										Meat.botBottom.width/1920 * _width, Meat.botBottom.height/1080*_height);

		_ctx.save();
		_ctx.fillStyle = '#5B97AB';
		var offsetLightX = 105 / 1920 * _width,
			offsetLightY = 85 / 1080 * _height,
			lightSize = 50 / 1920 * _width,
			aniX = Math.sin(row * 0.2) * (60 / 1920 * _width),
			aniY = (Math.sin(row * 0.2) * (5 / 1920 * _width)) * -1;
		_ctx.globalCompositeOperation = 'color-dodge';
		_ctx.drawImage(Meat.light, _botX + (470 /1920 * _width) + offsetLightX + aniX, _botY + headY + offsetLightY + aniY, lightSize, lightSize);
		_ctx.restore();

		var glow = _glow.getValue(row),
			bF = _blackFade.getValue(row);

		if (bF > 0) {
			_ctx.fillStyle = "rgba(0,0,0," + bF + ")";
			_ctx.fillRect(0, 0, _width, _height);
		}

		if (glow > 0) {
			var glowScale = 1;

			for (var i = 0; i < 4; i++) {
				glowScale += .01;
				var sW = _width * glowScale,
					sH = _height * glowScale;
				_ctx.save();
				_ctx.globalCompositeOperation = 'lighter';
				_ctx.globalAlpha = glow;
				_ctx.drawImage(_ctx.canvas, (_width - sW) / 2, (_height - sH) / 2, sW, sH);
				_ctx.restore();
			}
		}
		_ctx.save();
		_ctx.globalCompositeOperation = "multiply";
		_ctx.drawImage(Meat.vignette, 0, 0, _width, _height);
		_ctx.restore();
	}

	function clear() {
		_model.on("resize", function () {
		});
	}

	function resize(width, height) {
		_width = width;
		_height = height;
	}

	return {
		preflight: preflight,
		init: init,
		render: render,
		clear: clear,
		resize: resize
	};
}());