var Title = (function () {

	"use strict";

	var _model,
		_duration = 0,
		_sync,
		_width,
		_height,
		_ctx,
		_preflightCallback,
		_t,
		_s;

	var _blackFade,
		_glow,
		_sYoff,
		_tileScale,

		_magJPAlpha,
		_stripesAlpha,
		_magnetarAlpha,
		_logosAlpha;

	function preflight(callbackFn, duration, model) {
		_preflightCallback = callbackFn;

		_duration = duration;
		_model = model;

		_sync = _model.sync;
		_width = _model.width();
		_height = _model.height();

		initSync();

		_ctx = _model.twoDeeRenderer;

		_preflightCallback();

		//barHeight = _height/2.5;
	}

	function init() {
		_model.on("resize", resize);

		Random.seed(243234234, 456456234, 456456546, 3446534435);

		_t = new TileTwister();
		_t.setContext(_ctx);

		_s = new Starfield();
		_s.setContext(_ctx);
		_s.setCenter(_width/2, _height);
	}

	function initSync() {
		_blackFade = _sync.getTrack('blackFade');
		_glow = _sync.getTrack('glow');

		_magJPAlpha = _sync.getTrack('02:magJPAlpha');
		_stripesAlpha = _sync.getTrack('02:stripesAlpha');
		_magnetarAlpha = _sync.getTrack('02:magnetarAlpha');
		_logosAlpha = _sync.getTrack('02:logosAlphaAlpha');
		_sYoff = _sync.getTrack('0:sYOff');
		_tileScale = _sync.getTrack('0:tileScale');
	}

	function render(row, sceneTime, frameDelta) {
		_ctx.fillStyle = '#8c284b';
		_ctx.fillRect(0, 0, _width, _height);

		_ctx.save();
		_ctx.globalAlpha = .5;
		_ctx.drawImage(Meat.pattern, 0, (_height - (Meat.pattern.height / 1080 * _height)) * 0.5, Meat.pattern.width / 1920 * _width, Meat.pattern.height / 1080 * _height);
		_ctx.restore();

		_ctx.save();
		_s.setCenter(_width * 0.5, (_height * 0.5) + (_sYoff.getValue(row)) / 1080 * _height);
		_s.render(frameDelta/100);
		_ctx.restore();

		_ctx.drawImage(Meat.titleOff, 0, 0, _width, _height);
		_ctx.save();
		_ctx.globalAlpha = _magJPAlpha.getValue(row);
		_ctx.drawImage(Meat.magnetarJP, 206 / 1920 * _width, 383 / 1080 * _height, Meat.magnetarJP.width / 1920 * _width, Meat.magnetarJP.height / 1080 * _height);
		_ctx.restore();

		_ctx.save();
		_ctx.globalAlpha = _stripesAlpha.getValue(row);
		_ctx.drawImage(Meat.titleStripes, 205 / 1920 * _width, 376 / 1080 * _height, Meat.titleStripes.width / 1920 * _width, Meat.titleStripes.height / 1080 * _height);
		_ctx.restore();

		_ctx.save();
		_ctx.globalAlpha = _stripesAlpha.getValue(row);
		_ctx.drawImage(Meat.magnetar, 206 / 1920 * _width, 309 / 1080 * _height, Meat.magnetar.width / 1920 * _width, Meat.magnetar.height / 1080 * _height);
		_ctx.restore();

		_ctx.save();
		_ctx.globalAlpha = _logosAlpha.getValue(row);
		_ctx.drawImage(Meat.logos, 210 / 1920 * _width, 580 / 1080 * _height, Meat.logos.width / 1920 * _width, Meat.logos.height / 1080 * _height);
		_ctx.restore();

		_t.setScale(_tileScale.getValue(row));
		_t.render(row);

		var glow = _glow.getValue(row),
			bF = _blackFade.getValue(row);

		if (bF > 0) {
			_ctx.fillStyle = "rgba(0,0,0," + bF + ")";
			_ctx.fillRect(0, 0, _width, _height);
		}

		if (glow > 0) {
			var glowScale = 1;

			for (var i = 0; i < 4; i++) {
				glowScale += .01;
				var sW = _width * glowScale,
					sH = _height * glowScale;
				_ctx.save();
				_ctx.globalCompositeOperation = 'lighter';
				_ctx.globalAlpha = glow;
				_ctx.drawImage(_ctx.canvas, (_width - sW) / 2, (_height - sH) / 2, sW, sH);
				_ctx.restore();
			}
		}

		_ctx.drawImage(Meat.vignette, 0, 0, _width, _height);
	}

	function clear() {
		_model.on("resize", function () {
		});
	}

	function resize(width, height) {
		_width = width;
		_height = height;
	}

	return {
		preflight: preflight,
		init: init,
		render: render,
		clear: clear,
		resize: resize
	};
}());