function DemoDemo() {
	"use strict";
	DemoBase.call(this);
	this.init();
}

DemoDemo.prototype = Object.create(DemoBase.prototype);

DemoDemo.prototype.init = function () {
	DemoBase.prototype.init.call(this);

	//set demo data here
	this.model.AUDIO_URL = "data/alpha_c_-_magnetar5";
	this.model.ROCKET_URL = "data/magnetar.rocket";
	this.model.BPM = 128.04878;
	this.model.ROWS_PER_BEAT = 8;
	this.model.volume = 1;
};

DemoDemo.prototype.initScenes = function () {

	DemoBase.prototype.initScenes.call(this);
	this.sceneList.add(Intro, 0, 448);
	this.sceneList.add(Title, 448, 900);
	this.sceneList.add(MetaBot, 900, 1200);
	this.sceneList.add(LineBlob, 1200, 1600);
	this.sceneList.add(HopalongTunnel, 1600, 2048);
	this.sceneList.add(PolTunnel, 2048, 2200);
	this.sceneList.add(FlowerParty, 2200, 2559);
	this.sceneList.add(Credits, 2559, 2560);
	this.sceneList.preflight();
};

DemoDemo.prototype.constructor = DemoDemo;