uniform vec2 Resolution;

uniform sampler2D Tex;
uniform float Spread, Strength;
uniform vec3 Color;
uniform float BackgroundMix;

varying vec2 TexCoord;

vec3 sample(vec2 pos)
{
	return texture2D(Tex, pos / Resolution).xyz;
}

void main()
{
	vec2 pos = TexCoord * Resolution;

	vec3 center = sample(pos);
	vec3 left = sample(pos - vec2(Spread, 0));
	vec3 right = sample(pos + vec2(Spread, 0));
	vec3 up = sample(pos + vec2(0, Spread));
	vec3 down = sample(pos - vec2(0, Spread));

	float d1 = distance(center, left);
	float d2 = distance(center, right);
	float d3 = distance(center, up);
	float d4 = distance(center, down);

	float fade = clamp((d1 + d2 + d3 + d4) * Strength, 0.0, 1.0);

	gl_FragData[0] = vec4(center * BackgroundMix + Color * fade, 1);
}
