#version 120

uniform vec4 EyePos;
uniform vec4 LightPos;

varying vec3 normal;
varying vec3 pos;

uniform sampler2D tex;

vec3 Reflect( vec3 vec, vec3 normal )
{
	return 2.0f*dot(vec,normal)*normal-vec;
}

void main(void)
{
	vec3 lightPos = LightPos.xyz;
	
	// normal
	vec3 normalResult = normal;
	if ( gl_FrontFacing ) { normalResult *= -1.0f;}


	vec3 vecToEye = normalize( EyePos.xyz - pos );
	vec3 vecToLight = lightPos-pos;
	vec3 vecToLightNorm = normalize(vecToLight);
	vec3 vecReflectionLight = Reflect( vecToLightNorm, normalResult );
	vec3 halfVector = normalize( vecToEye + vecToLightNorm );

	float attenRadius = 1.0f;
	float attenuation = 1.0f-smoothstep( 0.0f, attenRadius, length(vecToLight) );
	//float specular = pow( max(0.0f,dot(halfVector, normalResult)), 5.0f );
	float specular = pow( dot(vecReflectionLight, vecToEye), 3.0f)*2.0f;
	float phong = pow(dot(vecToLight, normalResult)*0.5f+0.5f, 2.0f);
	float fresnel = pow(1.0f-dot(vecToEye, normalResult), 2.0f);

	
	vec4 colorTex =  texture2D(tex, normalize(vecToEye+normalResult).xz*0.5f+vec2(0.5f) );
	vec3 iridescence =  (vec3(1.0f)-colorTex.xyz)*5.0f;
	
	
	vec3 finalColor = attenuation*(vec3(phong) + vec3(specular) +iridescence);

	gl_FragColor = vec4( finalColor.xyz, 1.0f );
	
	//gl_FragColor = vec4( vec3(fresnel), 1.0f );	
}