__kernel void curlnel(
					  __read_only image3d_t volume, 
					  sampler_t volumeSampler, 
					  __global float4 *output, 
					  float speed
					  )
{
	uint index = get_global_id(0);
    uint numParticles = get_global_size(0);
	float indexNormalized = (float)index/numParticles;

    // read from 3D texture
	float4 vertData = output[index];

	float3 samplePos = vertData.s012;
	samplePos = samplePos+(float3)(0.5f);

    float4 voxel = (read_imagef(volume, volumeSampler, (float4)(samplePos,1.0f)));

	vertData.s012 += voxel.xyz*speed;

	output[index] = vertData;
}
