#version 120

uniform vec4 MiscFP;
uniform sampler2D texPerlin;
uniform sampler2D texNormal;

varying vec3 pos;
varying vec2 uv;
varying vec4 data;


void main(void)
{
	vec2 uvNormalized = uv*2.0f-1.0f; // [-1,1]
	float fade = 1.0f - smoothstep(  0.4f, 1.0f, length(uvNormalized) );
	
	float time = MiscFP.x;
	float alpha = MiscFP.y;
	
	vec2 uvFinal = uv*0.3f + data.xy + data.zw*time*0.1f;
	float perlin = texture2D( texPerlin, uvFinal ).x;
	
	gl_FragColor = vec4(vec3(perlin), perlin * fade * alpha);
}