ig.module(
    'plugins.inputBox'
)
.requires(
    'impact.impact'
)

.defines(function() {

ig.InputBox = ig.Class.extend({
        defaultMaxLength: 255,

        input_boxes: [], // Store input boxes in this list.
        mpos: {x: -1, y: -1}, // Store mouse position.

        init : function() {
        },

        createInputBox: function(x, y, size, textLength, fontSize, font){
            var input_box = document.createElement('input');
            input_box.type = 'text';
            input_box.value = '';

            // Set size x.
            input_box.style.width = size+"px";
            input_box.clientWidth = size+"px";  

            // Set size y.
            input_box.style.height = fontSize+"px";
            input_box.clientHeight = fontSize+"px";  

            // Set font size.
            input_box.style.fontSize = fontSize+"px";

            // Set font.
            input_box.style.fontFamily = font;
            
            input_box.style.pointerEvents = "auto";
            input_box.style.position = "absolute";
            input_box.style.top = y+"px";
            input_box.style.left = x+"px";

            input_box.style.backgroundColor = "#e6ddd4";
            input_box.style.borderColor = "#e6ddd4";
            input_box.style.outlineColor = "#FFFFFF";

            // Store for mouse cursor hit testing.
            input_box.sizex = size + 5;
            input_box.sizey = fontSize + 7;
            input_box.x = x-1;
            input_box.y = y-1;

            if(textLength){
                input_box.maxLength = textLength;
            } else {
                input_box.maxLength = this.defaultMaxLength;
            }

            // Handle input.
            var doc = document.getElementById("inputDiv").appendChild(input_box);

            document.getElementById("inputDiv").appendChild(input_box);

            // Store inout box in list of input boxes.
            this.input_boxes.push( input_box );

            return input_box;
        },

        removeElement: function(elem) {
            document.getElementById("inputDiv").removeChild(elem);

            for(var i = 0; i < this.input_boxes.length; i++) {
                if(elem === this.input_boxes[i]) {
                    // Remove from list of input boxes.
                    this.input_boxes.splice(i, 1);
                }
            }
        },

        // Check if mouse cursor is intersecting any input boxes.
        mouseCursorIntersecting: function() {
            for(var i = 0; i < this.input_boxes.length; i++) {
                if((this.input_boxes[i].x < ig.input.mouse.x)
                &&(this.input_boxes[i].x + this.input_boxes[i].sizex > ig.input.mouse.x)
                &&(this.input_boxes[i].y < ig.input.mouse.y)
                &&(this.input_boxes[i].y + this.input_boxes[i].sizey > ig.input.mouse.y)) {
                    // Return intersecting an input box.
                    return true;
                }
            }

            return false;
        },

        removeAll: function() {
            for(var i = 0; i < this.input_boxes.length; i++) {
                // Remove from list of input boxes.
                document.getElementById("inputDiv").removeChild(this.input_boxes[i]);
            }

            this.input_boxes.splice(0, this.input_boxes.length);
        },

        createTextArea: function(x, y, sizex, sizey, textLength, fontSize, font){
            var input_box = document.createElement('textArea');
            input_box.value = '';

            // Set size x.
            input_box.style.width = sizex+"px";
            input_box.clientWidth = sizex+"px";

            // Set size y.
            input_box.style.height = sizey+"px";
            input_box.clientHeight = sizey+"px";

            // Set font size.
            input_box.style.fontSize = fontSize+"px";

            // Set font.
            input_box.style.fontFamily = font;

            input_box.style.pointerEvents = "auto";
            input_box.style.position = "absolute";
            input_box.style.top = y+"px";
            input_box.style.left = x+"px";

            // Store for mouse cursor hit testing.
            input_box.sizex = sizex + 7;
            input_box.sizey = sizey + 7;
            input_box.x = x -1;
            input_box.y = y -1;

            if(textLength){
                input_box.maxLength = textLength;
            } else {
                input_box.maxLength = this.defaultMaxLength;    
            }
            
            document.getElementById("inputDiv").appendChild(input_box);

            // Store inout box in list of input boxes.
            this.input_boxes.push( input_box );

            return input_box;
        },

        // Handles input from the input box.
        handleInput: function(e){
            // Get key code.
            var key = e.keyCode;

            // If key code equals ENTER.
            if(key === 13) {
                // If chat is not null and not hiding while having been inited.
                if(ig.game.chat !== null && ig.game.chat.hide === false) {
                    ig.game.chat.enterText();
                }
            }
        }
    });
});