ig.module( 
    'game.entities.spawncoins' 
)
.requires(
    'impact.entity' 
)

.defines(function(){

// Play this when a character spawns in a or leaves a map.
EntitySpawncoins = ig.Entity.extend({

    animSheet: new ig.AnimationSheet( 'media/c.png', 30, 30 ),
    collides: ig.Entity.COLLIDES.NEVER,
    stimer: new ig.Timer(1),
    has_coin: false,
    has_potion: false,
    id: -1,

    init: function( x, y, settings ) {
        this.parent(x, y, settings);

        //this.addAnim('default', 1, [0] );
    },

    update: function() {
    	if(ig.game.host && !this.has_coin && !this.has_potion) {
    		if(this.stimer.delta() > 0) {
    			this.stimer.reset(2);

    			var rnum = Math.floor(Math.random()*5);

    			if(rnum === 0 || rnum === 1) { // Spawn coins. 2/5 chance.
    				this.spawnCoin();

                    // Notify clients.
                    ig.game.gamesocket.send(
                        'broadcast',
                        {   
                            t: "sc",
                            id: this.id,
                            key: ig.game.roomid
                        }
                    );

    				// Notice clients.
    			} else if(rnum === 2) { // Spawn potion. 1/5 chance.
    				this.spawnPotion(); 

                    // Notify clients.
                    ig.game.gamesocket.send(
                        'broadcast',
                        {   
                            t: "sp",
                            id: this.id,
                            key: ig.game.roomid
                        }
                    );
    			} else { // 2/5 chance.
    				// .. spawn nothing.
    			}
    		}
    	}
    },

    spawnCoin: function() {
    	if(ig.game.debug)
    		console.log("Spawned coin at spawncoin entity with id: " + this.id + ".");
		
		var new_coins = ig.game.spawnEntity(EntityCoins, this.pos.x, this.pos.y, {id:this.id});
		ig.game.coins.push(new_coins);
		this.has_coin = true;   	   
    },

    spawnPotion: function() {
        if(ig.game.debug)
    		console.log("Spawned potion at spawncoin entity with id: " + this.id + ".");	

		var new_potion = ig.game.spawnEntity(EntityPotion, this.pos.x, this.pos.y, {id:this.id});
		ig.game.potions.push(new_potion);
		this.has_potion = true;  
    },
        draw:function()
    {
        
    }
})
});