ig.module( 
    'game.entities.pirate' 
)
.requires(
    'impact.entity' 
)

.defines(function(){

// Play this when a character spawns in a or leaves a map.
EntityPirate = ig.Entity.extend({

    animSheet: new ig.AnimationSheet( 'media/pirate.png', 54, 86.6 ),
    collides: ig.Entity.COLLIDES.NEVER,
    size: {x: 54, y: 70},
    offset: {x: 0, y: 0},

    is_player: false,

    hp: 3,
    id: "", // Nick/id.
    score: 0,
    can_attack: true,
    attacking: false,
    digging: false,
    lifitng: false,


    zIndex: 10,

    // Walk speed.
    maxVel: {x: 300, y: 300},
    def_walk_speed: 300,
    carry_walk_speed: 180,
    walk_speed: 300,

    last_state: null,

    alpha_value: 1.0,
    alpha_dir: 0,
    damaged: false,
    angle: 0,

    init: function( x, y, settings ) {
        this.parent(x, y, settings);

        this.addAnim('idle', 1, [0] );
        this.addAnim('walk', 0.2, [0,1,2,3,4,5,6,7,8,9,10,11] );
        this.addAnim('attack', 0.2, [12, 13] );

        this.id = settings.id;

        this.state = 4;
    },

    // ChangeState
    changeStatePos: function(state, x, y) { 
        this.pos.x = x;
        this.pos.y = y;
        this.state = state;
    },

    changeState: function(state) {
         this.state = state;
    },

    // States.
    // 0 - 1 - 2
    // 3 - 4 - 5
    // 6 - 7 - 8
    walk: function(state) { 
        // Reset velocity.
        this.vel.x = 0;
        this.vel.y = 0;

        switch(state) {
            case 0:
                this.vel.x = -(this.walk_speed/2);
                this.vel.y = -(this.walk_speed/2);
                break;    

            case 1:
                this.vel.y = -this.walk_speed;
                break;

            case 2:
                this.vel.x = (this.walk_speed/2);
                this.vel.y = -(this.walk_speed/2);
                break;

            case 3:
                this.vel.x = -this.walk_speed;
                break;

            case 4:
                break;

            case 5:
                this.vel.x = this.walk_speed;
                break;

            case 6:
                this.vel.x = -(this.walk_speed/2);
                this.vel.y = (this.walk_speed/2);
                break;

            case 7:
                this.vel.y = this.walk_speed;
                break;

            case 8:
                this.vel.x = (this.walk_speed/2);
                this.vel.y = (this.walk_speed/2);
                break;
        }

        if(this.state === 4 && !this.attacking) {
            // Change to idle.
            this.currentAnim = this.anims.idle;
        }

        else if(!this.attacking)
        {
            // Change to walk anim.
            this.currentAnim = this.anims.walk;
        }
    },

    damage: function() {
        this.damaged = true;
        this.alpha_dir = 0;
    },

    update: function() {
        this.parent();
        
        this.walk(this.state);

        // After playing attack anim, set to default anims.
        if(this.currentAnim === this.anims.attack && this.currentAnim.loopCount > 0) {
            console.log("KLO");
            this.attacking = false;
        }

        if(this === ig.game.player) {
            this.rotateTowardsCamera();
        }

        // Play alpha value animation if damaged.
        if(this.damaged === true) {
            if(this.alpha_dir === 0) {
                this.alpha_value -= 5 * ig.system.tick;
                if(this.alpha_value < 0.2) {
                    this.alpha_dir = 1;
                }
            } else {
                this.alpha_value += 5 * ig.system.tick;

                if(this.alpha_value >= 1) {
                    this.alpha_value = 1;
                    this.damaged = false;
                }
            }

            this.currentAnim.alpha = this.alpha_value;
        }   
    },

    setAngle: function(angle) {
        this.angle = angle;
        this.currentAnim.angle = -angle;
    },

    rotateTowardsCamera: function() {
        this.angle = this.angleToMouse();
        this.currentAnim.angle = -this.angle;
    },

    angleToMouse: function( other ) {
        return Math.atan2(
            this.pos.x - ig.game.screen.x + (this.size.x/2) - ig.input.mouse.x,
            this.pos.y - ig.game.screen.y + (this.size.y/2) - ig.input.mouse.y - 10
        );
    },

    // Pirate hits and plays hit animation.
    hit: function(rotation) {
        // Change anim.
        this.angle = rotation;
        this.currentAnim = this.anims.attack.rewind();
        this.currentAnim.angle = -this.angle;

        this.attacking = true;
    },

    dig: function() {
        // Change anim.

        this.resetWalkSpeed();
    },

    digUp: function() {
        // Change anim.

        this.resetWalkSpeed();
    },

    carryChest: function() {
        // Change anim.

        this.walk_speed = this.carry_walk_speed;
    },

    resetWalkSpeed:  function() {
        this.can_attack = true;
        this.walk_speed = this.def_walk_speed;
    }
})
});