ig.module( 
    'game.entities.chest' 
)
.requires(
    'impact.entity' 
)

.defines(function(){

// Play this when a character spawns in a or leaves a map.
EntityChest = ig.Entity.extend({

    animSheet: new ig.AnimationSheet( 'media/chest.png', 42, 48 ),
    size: {x: 42, y: 48},
    collides: ig.Entity.COLLIDES.NEVER,
    owner_id: -1,
    zIndex: 5,

    init: function( x, y, settings ) {
        this.parent(x, y, settings);

        this.addAnim('default', 1, [0] );

        console.log(this.pos.x, this.pos.y);

        if(!ig.editor){
            // Re-sort Entities
            ig.game.sortEntitiesDeferred();
        }
    },

    update: function () {
        this.parent();
    },

    pickup: function(pirate_id) {

    },

    digdown: function() {

    },

    digup: function() {

    },

    draw:function() {
        this.parent();
    }
})
});