uniform sampler2D Tex;
varying vec2 TexCoord;
varying vec4 Color;
void main()
{
	float maxFogDistance = 6.0;
	vec3 l = normalize(lightPos - worldPosition.xyz);
	vec3 fogColor = getFogColor(viewPosition,lightPos,worldPosition.xyz)+(vec3(0.05,0.1,0.2));
	fogColor *= clamp(l.y*2.0,0.0,1.0);
	vec4 TexColor =texture2D(Tex,TexCoord);
	vec4 tempfinal =  vec4(mix(TexColor.xyz, fogColor, clamp(length(viewPosition) / maxFogDistance-(l.y), 0.0, 1.0)), 1);
	tempfinal =  vec4(mix(TexColor.xyz, fogColor, smoothstep(0.0,2.5,length(viewPosition) / maxFogDistance)),1.0);
	gl_FragColor = tempfinal * Color;
}