#version 430 core

uniform vec3 camPos;
uniform vec3 camDir;
uniform vec3 vsCenter;
uniform float vsSize;

layout(triangles) in;
layout(points, max_vertices = 256) out;

void main()
{
	vec3 p0 = gl_in[0].gl_Position.xyz;
	vec3 e10 = gl_in[1].gl_Position.xyz - p0;
	vec3 e20 = gl_in[2].gl_Position.xyz - p0;
	vec3 pn = cross(e10, e20);
	//float area = length(pn);
	//if ( area > 5.0 ) return;
#if 1
	int visible = 0;
	for (int i=0; i < 3; i++)
	{
		vec3 diff = camPos - gl_in[i].gl_Position.xyz;
		float l = length(diff);
		float d = dot(pn, normalize(diff));
		if ( d > -0.2 && l < 100.0 ) visible++;
	}
	if ( visible < 1 ) return;
#endif

#if 1
	float uStep = vsSize / max(length(e10), 1.0/256.0);
	float vStep = vsSize / max(length(e20), 1.0/256.0);
#else
	float uLen = length(e10);
	float vLen = length(e20);
	float uStep = vsSize / uLen;
	float vStep = vsSize / vLen;
#endif

	int count = 0;
	vec3 prevCoord = vec3(1.0e7);
	float minStep = min(uStep, vStep);
	for (float u=uStep*0.5; u < 1.0; u+=uStep)
	{
		for (float v=vStep*0.5; v < 1.0; v+=vStep)
		{
			vec3 pos = p0 + e10*u + e20*v;

			vec3 grid = (pos / vsSize) + vsCenter;
			vec3 gridTrunc = trunc(grid);
			vec3 zeroTest = gridTrunc - prevCoord;
			if ( dot(zeroTest, zeroTest) >= minStep )
			{
				prevCoord = gridTrunc;
				vec3 gridFrac = abs(grid - gridTrunc);
				float l = length(gridFrac);
				float size = l / sqrt(1.5);

				gl_Position.xyz = (gridTrunc - vsCenter) * vsSize;
				gl_Position.w = mix(0.1, 1.0, min(size*2.0, 1.0)) * vsSize;
				EmitVertex();
				EndPrimitive();
				count++;
				if ( count > 255 ) return;
			}
		}
	}
}
