#version 330 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat4 ModelViewMatrix;
uniform mat3 NormalMatrix;

// max 32 skinning matrices
uniform mat4 boneMatrix[32];

layout (location = 0) in vec3 POSITION;
layout (location = 1) in vec3 NORMAL;
layout (location = 4) in vec2 TEXCOORD;
layout (location = 5) in vec4 BONE_INDEX;
layout (location = 6) in vec4 BONE_WEIGHT;

out vec2 pos_zw;
out vec3 normal;
out vec3 ec_pos;
out vec2 uv;

void main()
{
	ivec4 matrixIndex = ivec4(BONE_INDEX);
	vec4 pos = vec4(0.0);
	vec3 norm = vec3(0.0);
#if 0
	for (int i=0; i < 4; i++)
	{
		pos  += (boneMatrix[ matrixIndex[i] ] * vec4(POSITION, 1.0)) * BONE_WEIGHT[i];
		norm += (mat3(boneMatrix[ matrixIndex[i] ]) * NORMAL) * BONE_WEIGHT[i];
	}
#else
	pos  += (boneMatrix[ matrixIndex.x ] * vec4(POSITION, 1.0)) * BONE_WEIGHT.x;
	norm += (mat3(boneMatrix[ matrixIndex.x ]) * NORMAL) * BONE_WEIGHT.x;

	pos  += (boneMatrix[ matrixIndex.y ] * vec4(POSITION, 1.0)) * BONE_WEIGHT.y;
	norm += (mat3(boneMatrix[ matrixIndex.y ]) * NORMAL) * BONE_WEIGHT.y;

	pos  += (boneMatrix[ matrixIndex.z ] * vec4(POSITION, 1.0)) * BONE_WEIGHT.z;
	norm += (mat3(boneMatrix[ matrixIndex.z ]) * NORMAL) * BONE_WEIGHT.z;

	pos  += (boneMatrix[ matrixIndex.w ] * vec4(POSITION, 1.0)) * BONE_WEIGHT.w;
	norm += (mat3(boneMatrix[ matrixIndex.w ]) * NORMAL) * BONE_WEIGHT.w;
#endif
	pos.w = 1.0;

	//pos.xyz = POSITION + pos.xyz*0.00000001;
	//norm = NORMAL + norm*0.00000001;

	uv = TEXCOORD;
	normal = NormalMatrix * normalize(norm);

	ec_pos = vec3(ModelViewMatrix * pos);

	vec4 proj_pos = ModelViewProjectionMatrix * pos;
	pos_zw = proj_pos.zw;
	gl_Position = proj_pos;
}
